/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.NameIterator;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;

public class QuarkusConfigBuilderCustomizer
implements SmallRyeConfigBuilderCustomizer {
    public void configBuilder(SmallRyeConfigBuilder builder) {
        final LaunchMode launchMode = ProfileManager.getLaunchMode();
        builder.withDefaultValue(launchMode.getProfileKey(), launchMode.getDefaultProfile());
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new RelocateConfigSourceInterceptor(Map.of("smallrye.config.profile", launchMode.getProfileKey()));
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3190);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                final HashMap<String, String> relocations = new HashMap<String, String>();
                relocations.put("smallrye.config.locations", "quarkus.config.locations");
                relocations.put("smallrye.config.profile.parent", "quarkus.config.profile.parent");
                relocations.put("smallrye.config.mapping.validate-unknown", "quarkus.config.mapping.validate-unknown");
                relocations.put("smallrye.config.log.values", "quarkus.config.log.values");
                return new RelocateConfigSourceInterceptor((Function)new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        String relocate = (String)relocations.get(name);
                        if (relocate != null) {
                            return relocate;
                        }
                        if (name.startsWith("%") && name.endsWith("smallrye.config.locations")) {
                            NameIterator ni = new NameIterator(name);
                            return ni.getNextSegment() + ".quarkus.config.locations";
                        }
                        if (name.startsWith("%") && name.endsWith("smallrye.config.profile.parent")) {
                            NameIterator ni = new NameIterator(name);
                            return ni.getNextSegment() + ".quarkus.config.profile.parent";
                        }
                        return name;
                    }
                });
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3195);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                HashMap<String, String> fallbacks = new HashMap<String, String>();
                fallbacks.put("quarkus.profile", "smallrye.config.profile");
                fallbacks.put("quarkus.config.locations", "smallrye.config.locations");
                fallbacks.put("quarkus.config.profile.parent", "smallrye.config.profile.parent");
                fallbacks.put("quarkus.config.mapping.validate-unknown", "smallrye.config.mapping.validate-unknown");
                fallbacks.put("quarkus.config.log.values", "smallrye.config.log.values");
                return new FallbackConfigSourceInterceptor(fallbacks);
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3595);
            }
        }});
        builder.withMappingIgnore("quarkus.**");
    }
}

