/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(name="datasource", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public class DataSourcesBuildTimeConfig {
    @ConfigItem(name="<<parent>>")
    public DataSourceBuildTimeConfig defaultDataSource;
    @ConfigItem(name="<<parent>>")
    public Map<String, DataSourceBuildTimeConfig> namedDataSources;
    @ConfigItem(name="health.enabled", defaultValue="true")
    public boolean healthEnabled;
    @ConfigItem(name="metrics.enabled")
    public boolean metricsEnabled;
    @Deprecated
    public Optional<String> url;
    @Deprecated
    public Optional<String> driver;

    public DataSourceBuildTimeConfig getDataSourceRuntimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.defaultDataSource;
        }
        DataSourceBuildTimeConfig dataSourceBuildTimeConfig = this.namedDataSources.get(dataSourceName);
        if (dataSourceBuildTimeConfig == null) {
            return new DataSourceBuildTimeConfig();
        }
        return dataSourceBuildTimeConfig;
    }
}

