/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.runtime;

import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourceSupport;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Recorder
public class DataSourceRecorder {
    public RuntimeValue<DataSourceSupport> createDataSourceSupport(DataSourcesBuildTimeConfig buildTimeConfig, DataSourcesRuntimeConfig runtimeConfig) {
        Stream.Builder<String> configured = Stream.builder();
        Stream.Builder<String> excludedForHealthChecks = Stream.builder();
        for (Map.Entry<String, DataSourceBuildTimeConfig> dataSource : buildTimeConfig.dataSources().entrySet()) {
            if (dataSource.getValue().dbKind().isPresent()) {
                configured.add(dataSource.getKey());
            }
            if (!dataSource.getValue().healthExclude()) continue;
            excludedForHealthChecks.add(dataSource.getKey());
        }
        Set<String> names = configured.build().collect(Collectors.toUnmodifiableSet());
        Set<String> excludedNames = excludedForHealthChecks.build().collect(Collectors.toUnmodifiableSet());
        Stream.Builder<String> inactive = Stream.builder();
        for (Map.Entry<String, DataSourceRuntimeConfig> entry : runtimeConfig.dataSources().entrySet()) {
            if (entry.getValue().active()) continue;
            inactive.add(entry.getKey());
        }
        Set<String> inactiveNames = inactive.build().collect(Collectors.toUnmodifiableSet());
        return new RuntimeValue((Object)new DataSourceSupport(names, excludedNames, inactiveNames));
    }
}

