/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment.compose;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.ContainerRuntimeStatusBuildItem;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.ComposeBuildTimeConfig;
import io.quarkus.deployment.dev.devservices.ComposeDevServicesBuildTimeConfig;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.dev.devservices.RunningContainer;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.devservices.common.ContainerUtil;
import io.quarkus.devservices.deployment.compose.ComposeFiles;
import io.quarkus.devservices.deployment.compose.ComposeProject;
import io.quarkus.devservices.deployment.compose.ComposeServiceWaitStrategyTarget;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.mutiny.unchecked.Unchecked;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
public class ComposeDevServicesProcessor {
    private static final Logger log = Logger.getLogger(ComposeDevServicesProcessor.class);
    static final String PROJECT_PREFIX = "quarkus-devservices";
    static final Pattern COMPOSE_FILE = Pattern.compile("(^docker-compose|^compose)(-dev(-)?service).*.(yml|yaml)");
    static volatile ComposeRunningService runningCompose;
    static volatile ComposeDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.COMPOSE);
    }

    @BuildStep
    public void watchComposeFiles(ComposeBuildTimeConfig composeBuildTimeConfig, BuildProducer<HotDeploymentWatchedFileBuildItem> producer) {
        if (composeBuildTimeConfig.devservices().enabled()) {
            composeBuildTimeConfig.devservices().files().ifPresentOrElse(files -> {
                for (File file : ComposeDevServicesProcessor.filesFromConfigList(files)) {
                    producer.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(file.getAbsolutePath()));
                }
            }, () -> producer.produce((BuildItem)HotDeploymentWatchedFileBuildItem.builder().setLocationPredicate(COMPOSE_FILE.asMatchPredicate()).build()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    public DevServicesComposeProjectBuildItem config(Executor buildExecutor, ComposeBuildTimeConfig composeBuildTimeConfig, ApplicationInfoBuildItem appInfo, LaunchModeBuildItem launchMode, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig, DockerStatusBuildItem dockerStatusBuildItem) throws IOException {
        ComposeDevServiceCfg configuration = new ComposeDevServiceCfg(composeBuildTimeConfig.devservices());
        if (runningCompose != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return runningCompose.toComposeBuildItem();
            }
            try {
                runningCompose.close();
            }
            finally {
                runningCompose = null;
                cfg = null;
            }
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Compose Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem, s -> s.getName().startsWith("ducttape") || s.getName().equals("Process stdout") || s.getName().startsWith("build-"));
        try {
            runningCompose = this.startCompose(buildExecutor, configuration, appInfo.getName(), (ContainerRuntimeStatusBuildItem)dockerStatusBuildItem, launchMode, devServicesConfig.timeout());
            if (runningCompose == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (RuntimeException e) {
            compressor.closeAndDumpCaptured();
            throw e;
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (runningCompose == null) {
            return new DevServicesComposeProjectBuildItem();
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (runningCompose != null) {
                    try {
                        runningCompose.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                first = true;
                runningCompose = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        return runningCompose.toComposeBuildItem();
    }

    @BuildStep
    public DevServicesResultBuildItem toDevServicesResult(DevServicesComposeProjectBuildItem composeBuildItem) {
        if (composeBuildItem.getProject() != null) {
            return new DevServicesResultBuildItem("Compose Dev Services", String.format("Project: %s, Services: %s", composeBuildItem.getProject(), String.join((CharSequence)", ", composeBuildItem.getComposeServices().keySet())), null, composeBuildItem.getConfig());
        }
        return null;
    }

    private ComposeRunningService startCompose(Executor buildExecutor, ComposeDevServiceCfg cfg, String appName, ContainerRuntimeStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        if (!cfg.devServicesEnabled) {
            log.debug((Object)"Not starting Compose dev services, as it has been disabled in the config.");
            return null;
        }
        if (cfg.files.isEmpty() && cfg.project == null) {
            log.debug((Object)"Not starting Compose dev services, no compose files found or project name provided.");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Docker isn't working, not starting Compose dev services.");
            return null;
        }
        ComposeFiles composeFiles = new ComposeFiles(cfg.files);
        Object projectName = ("quarkus-devservices-" + appName).toLowerCase();
        if (launchMode.getLaunchMode() != LaunchMode.DEVELOPMENT && !cfg.reuseProjectForTests) {
            projectName = (String)projectName + "-" + RandomStringUtils.insecure().nextAlphabetic(6).toLowerCase();
        } else if (cfg.project != null) {
            projectName = cfg.project;
        } else if (composeFiles.getProjectName() != null) {
            projectName = composeFiles.getProjectName();
        }
        if (composeFiles.getServiceDefinitions().isEmpty()) {
            log.info((Object)"No service definitions specified");
            return null;
        }
        ComposeProject.Builder builder = new ComposeProject.Builder(composeFiles, this.getComposeExecutable()).withProject((String)projectName).withEnv(cfg.envVariables).withStopContainers(cfg.stopServices).withRyukEnabled(cfg.ryukEnabled).withProfiles(cfg.profiles).withOptions(cfg.options).withRemoveImages(cfg.removeImages).withRemoveVolumes(cfg.removeVolumes).withFollowContainerLogs(cfg.followContainerLogs).withScalingPreferences(cfg.scalingPreferences).withStopTimeout(cfg.stopTimeout).withBuild(cfg.build);
        timeout.ifPresent(builder::withStartupTimeout);
        ComposeProject compose = builder.build();
        if (!cfg.startServices) {
            log.infof("Discovering existing Compose services for project %s", (Object)compose.getProject());
            compose.discoverServiceInstances(true);
            if (!compose.getServices().isEmpty()) {
                return new ComposeRunningService(compose, false);
            }
            return null;
        }
        compose.discoverServiceInstances(false);
        if (!compose.getServices().isEmpty()) {
            if (!cfg.files.isEmpty()) {
                compose.waitUntilServicesReady(buildExecutor);
            }
            log.infof("Discovered existing Compose services for project %s", (Object)compose.getProject());
            return new ComposeRunningService(compose, false);
        }
        if (cfg.files.isEmpty()) {
            log.debug((Object)"Could not find any compose files, not starting Compose dev services");
            return null;
        }
        try {
            compose.start();
        }
        catch (Exception e) {
            log.warnf("Could not start successfully Compose dev services for project %s, reason: %s", (Object)compose.getProject(), (Object)e.getMessage());
            if (cfg.stopServices) {
                try {
                    compose.stop();
                }
                catch (Exception e1) {
                    log.error((Object)"Failed to stop Compose dev services", (Throwable)e1);
                }
            }
            throw e;
        }
        compose.waitUntilServicesReady(buildExecutor);
        return new ComposeRunningService(compose, true);
    }

    private String getComposeExecutable() {
        return ContainerRuntimeUtil.detectContainerRuntime().getExecutableName() + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
    }

    static boolean isComposeFile(Path p) {
        return COMPOSE_FILE.matcher(p.getFileName().toString()).matches();
    }

    static Path getProjectRoot() {
        String gradlePath = System.getProperty("gradle.project.path");
        if (gradlePath != null) {
            return Path.of(gradlePath, new String[0]);
        }
        return Paths.get(System.getProperty("user.dir", "."), new String[0]).toAbsolutePath().normalize();
    }

    static List<File> filesFromConfigList(List<String> l) {
        return l.stream().map(f -> ComposeDevServicesProcessor.getProjectRoot().resolve((String)f).toAbsolutePath().normalize()).map(Path::toFile).collect(Collectors.toList());
    }

    static List<File> collectComposeFilesFromProjectRoot() throws RuntimeException {
        List<File> list;
        block8: {
            Stream<Path> list2 = Files.list(ComposeDevServicesProcessor.getProjectRoot().toAbsolutePath().normalize());
            try {
                list = list2.filter(ComposeDevServicesProcessor::isComposeFile).map(Path::toFile).collect(Collectors.toList());
                if (list2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list2 != null) {
                        try {
                            list2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            list2.close();
        }
        return list;
    }

    static {
        first = true;
    }

    private static class ComposeDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String project;
        private final boolean startServices;
        private final boolean stopServices;
        private final Duration stopTimeout;
        private final boolean ryukEnabled;
        private final List<File> files;
        private final List<String> profiles;
        private final List<String> options;
        private final String removeImages;
        private final Boolean build;
        private final boolean removeVolumes;
        private final boolean followContainerLogs;
        private final Map<String, String> envVariables;
        private final Map<String, Integer> scalingPreferences;
        private final boolean reuseProjectForTests;
        private final String filesSha;

        public ComposeDevServiceCfg(ComposeDevServicesBuildTimeConfig cfg) {
            MessageDigest md;
            this.devServicesEnabled = cfg.enabled();
            this.files = cfg.files().map(ComposeDevServicesProcessor::filesFromConfigList).orElseGet(ComposeDevServicesProcessor::collectComposeFilesFromProjectRoot);
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            Base64.Encoder encoder = Base64.getEncoder();
            this.filesSha = this.files.stream().sorted().map(Unchecked.function(f -> Files.readAllBytes(f.toPath()))).map(md::digest).map(encoder::encodeToString).collect(Collectors.joining());
            this.project = cfg.projectName().orElse(null);
            this.startServices = cfg.startServices();
            this.stopServices = cfg.stopServices();
            this.stopTimeout = cfg.stopTimeout();
            this.ryukEnabled = cfg.ryukEnabled();
            this.profiles = cfg.profiles().orElse(Collections.emptyList());
            this.options = cfg.options().orElse(Collections.emptyList());
            this.removeImages = cfg.removeImages().map(Enum::name).map(String::toLowerCase).orElse(null);
            this.removeVolumes = cfg.removeVolumes();
            this.envVariables = cfg.envVariables();
            this.scalingPreferences = cfg.scale();
            this.followContainerLogs = cfg.followContainerLogs();
            this.reuseProjectForTests = cfg.reuseProjectForTests();
            this.build = cfg.build().orElse(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComposeDevServiceCfg that = (ComposeDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.project, that.project) && Objects.equals(this.startServices, that.startServices) && Objects.equals(this.stopServices, that.stopServices) && Objects.equals(this.ryukEnabled, that.ryukEnabled) && Objects.equals(this.files, that.files) && Objects.equals(this.filesSha, that.filesSha) && Objects.equals(this.profiles, that.profiles) && Objects.equals(this.options, that.options) && Objects.equals(this.removeImages, that.removeImages) && Objects.equals(this.removeVolumes, that.removeVolumes) && Objects.equals(this.followContainerLogs, that.followContainerLogs) && Objects.equals(this.build, that.build) && Objects.equals(this.envVariables, that.envVariables) && Objects.equals(this.scalingPreferences, that.scalingPreferences) && Objects.equals(this.reuseProjectForTests, that.reuseProjectForTests);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.project, this.startServices, this.stopServices, this.ryukEnabled, this.files, this.filesSha, this.profiles, this.options, this.removeImages, this.removeVolumes, this.followContainerLogs, this.build, this.envVariables, this.scalingPreferences, this.reuseProjectForTests);
        }
    }

    private static class ComposeRunningService
    extends DevServicesResultBuildItem.RunningDevService {
        private final Map<String, List<RunningContainer>> composeServices;
        private final String defaultNetworkId;

        public ComposeRunningService(ComposeProject compose, boolean isOwner) {
            super(compose.getProject(), "compose", null, isOwner ? compose::stop : null, ComposeRunningService.configs(compose));
            this.composeServices = ComposeRunningService.composeServices(compose);
            this.defaultNetworkId = compose.getDefaultNetworkId();
        }

        static Map<String, String> configs(ComposeProject compose) {
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.putAll(compose.getEnvVarConfig());
            configs.putAll(compose.getExposedPortConfig());
            configs.put("com.docker.compose.project", compose.getProject());
            return configs;
        }

        static Map<String, List<RunningContainer>> composeServices(ComposeProject compose) {
            return compose.getServices().stream().collect(Collectors.groupingBy(ComposeServiceWaitStrategyTarget::getServiceName, Collectors.mapping(s -> ContainerUtil.toRunningContainer((InspectContainerResponse)s.getContainerInfo()), Collectors.toList())));
        }

        public DevServicesComposeProjectBuildItem toComposeBuildItem() {
            return new DevServicesComposeProjectBuildItem(this.getName(), this.defaultNetworkId, this.composeServices, this.getConfig());
        }
    }
}

