/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.UpdateProjectCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.util.HashMap;
import java.util.Objects;

public class UpdateProject {
    public static final String APP_MODEL = "quarkus.update-project.app-model";
    public static final String TARGET_CATALOG = "quarkus.update-project.target-catalog";
    public static final String REWRITE = "quarkus.update-project.rewrite.yes";
    public static final String TARGET_PLATFORM_VERSION = "quarkus.update-project.target-platform-version";
    public static final String REWRITE_PLUGIN_VERSION = "quarkus.update-project.rewrite.plugin-version";
    public static final String REWRITE_QUARKUS_UPDATE_RECIPES = "quarkus.update-project.rewrite.quarkus-update-recipes";
    public static final String REWRITE_ADDITIONAL_UPDATE_RECIPES = "quarkus.update-project.rewrite.additional-update-recipes";
    public static final String REWRITE_DRY_RUN = "quarkus.update-project.rewrite.dry-run";
    private final QuarkusCommandInvocation invocation;
    private final UpdateProjectCommandHandler handler = new UpdateProjectCommandHandler();

    public UpdateProject(QuarkusProject quarkusProject) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject);
    }

    public UpdateProject(QuarkusProject quarkusProject, MessageWriter messageWriter) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject, new HashMap<String, Object>(), messageWriter);
    }

    public UpdateProject targetCatalog(ExtensionCatalog latestCatalog) {
        this.invocation.setValue(TARGET_CATALOG, Objects.requireNonNull(latestCatalog, "targetCatalog is required"));
        return this;
    }

    public UpdateProject appModel(ApplicationModel applicationModel) {
        this.invocation.setValue(APP_MODEL, Objects.requireNonNull(applicationModel, "applicationModel is required"));
        return this;
    }

    public UpdateProject rewrite(boolean rewrite) {
        this.invocation.setValue(REWRITE, rewrite);
        return this;
    }

    public UpdateProject rewritePluginVersion(String rewritePluginVersion) {
        this.invocation.setValue(REWRITE_PLUGIN_VERSION, Objects.requireNonNull(rewritePluginVersion, "rewritePluginVersion is required"));
        return this;
    }

    public UpdateProject rewriteQuarkusUpdateRecipes(String rewriteQuarkusUpdateRecipes) {
        this.invocation.setValue(REWRITE_QUARKUS_UPDATE_RECIPES, Objects.requireNonNull(rewriteQuarkusUpdateRecipes, "rewriteQuarkusUpdateRecipes is required"));
        return this;
    }

    public UpdateProject rewriteAdditionalUpdateRecipes(String rewriteAdditionalUpdateRecipes) {
        this.invocation.setValue(REWRITE_ADDITIONAL_UPDATE_RECIPES, rewriteAdditionalUpdateRecipes);
        return this;
    }

    public UpdateProject rewriteDryRun(boolean rewriteDryRun) {
        this.invocation.setValue(REWRITE_DRY_RUN, rewriteDryRun);
        return this;
    }

    public UpdateProject targetPlatformVersion(String targetPlatformVersion) {
        this.invocation.setValue(TARGET_PLATFORM_VERSION, targetPlatformVersion);
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return this.handler.execute(this.invocation);
    }
}

