/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update.rewrite;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdateException;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdateExitErrorException;
import io.quarkus.qute.Qute;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QuarkusUpdateCommand {
    public static final String MAVEN_REWRITE_PLUGIN_GROUP = "org.openrewrite.maven";
    public static final String MAVEN_REWRITE_PLUGIN_ARTIFACT = "rewrite-maven-plugin";
    public static Set<String> ADDITIONAL_SOURCE_FILES_SET = Set.of("**/META-INF/services/**", "**/*.txt", "**/*.adoc", "**/*.md", "**/src/main/codestarts/**/*.java", "**/src/test/resources/__snapshots__/**/*.java", "**/*.kt");
    public static String ADDITIONAL_SOURCE_FILES = String.join((CharSequence)",", ADDITIONAL_SOURCE_FILES_SET);
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static String goal(boolean dryRun) {
        return dryRun ? "dryRun" : "run";
    }

    public static void handle(MessageWriter log, BuildTool buildTool, Path baseDir, String rewritePluginVersion, String recipesGAV, Path recipe, boolean dryRun) {
        switch (buildTool) {
            case MAVEN: {
                QuarkusUpdateCommand.runMavenUpdate(log, baseDir, rewritePluginVersion, recipesGAV, recipe, dryRun);
                break;
            }
            case GRADLE: {
                QuarkusUpdateCommand.runGradleUpdate(log, baseDir, rewritePluginVersion, recipesGAV, recipe, dryRun);
                break;
            }
            default: {
                throw new QuarkusUpdateException(buildTool.getKey() + " is not supported yet");
            }
        }
    }

    private static void runGradleUpdate(MessageWriter log, Path baseDir, String rewritePluginVersion, String recipesGAV, Path recipe, boolean dryRun) {
        Path tempInit = null;
        try {
            tempInit = Files.createTempFile("openrewrite-init", "gradle", new FileAttribute[0]);
            try (InputStream inputStream = QuarkusUpdateCommand.class.getResourceAsStream("/openrewrite-init.gradle");){
                String template = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                Files.writeString(tempInit, (CharSequence)Qute.fmt((String)template, Map.of("rewriteFile", recipe.toAbsolutePath().toString(), "pluginVersion", rewritePluginVersion, "recipesGAV", recipesGAV, "activeRecipe", "io.quarkus.openrewrite.Quarkus", "plainTextMask", ADDITIONAL_SOURCE_FILES_SET.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")))), new OpenOption[0]);
            }
            String gradleBinary = QuarkusUpdateCommand.findGradleBinary(baseDir);
            String[] command = new String[]{gradleBinary.toString(), "--console", "plain", "--stacktrace", "--init-script", tempInit.toAbsolutePath().toString(), dryRun ? "rewriteDryRun" : "rewriteRun"};
            QuarkusUpdateCommand.executeCommand(baseDir, command, log);
        }
        catch (QuarkusUpdateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuarkusUpdateException("Error while running Gradle rewrite command, see the execution logs above for more details", e);
        }
        finally {
            if (tempInit != null) {
                try {
                    Files.deleteIfExists(tempInit);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void runMavenUpdate(MessageWriter log, Path baseDir, String rewritePluginVersion, String recipesGAV, Path recipe, boolean dryRun) {
        String mvnBinary = QuarkusUpdateCommand.findMvnBinary(baseDir);
        QuarkusUpdateCommand.executeCommand(baseDir, QuarkusUpdateCommand.getMavenUpdateCommand(mvnBinary, rewritePluginVersion, recipesGAV, recipe, dryRun), log);
        QuarkusUpdateCommand.executeCommand(baseDir, QuarkusUpdateCommand.getMavenProcessSourcesCommand(mvnBinary), log);
    }

    private static String[] getMavenProcessSourcesCommand(String mvnBinary) {
        return new String[]{mvnBinary, "process-sources"};
    }

    private static String[] getMavenUpdateCommand(String mvnBinary, String rewritePluginVersion, String recipesGAV, Path recipe, boolean dryRun) {
        return new String[]{mvnBinary, "-e", String.format("%s:%s:%s:%s", MAVEN_REWRITE_PLUGIN_GROUP, MAVEN_REWRITE_PLUGIN_ARTIFACT, rewritePluginVersion, dryRun ? "dryRun" : "run"), String.format("-DplainTextMasks=%s", ADDITIONAL_SOURCE_FILES), String.format("-Drewrite.configLocation=%s", recipe.toAbsolutePath()), String.format("-Drewrite.recipeArtifactCoordinates=%s", recipesGAV), String.format("-DactiveRecipes=%s", "io.quarkus.openrewrite.Quarkus"), "-Drewrite.pomCacheEnabled=false"};
    }

    private static void executeCommand(Path baseDir, String[] command, MessageWriter log) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        log.info("");
        log.info("");
        log.info("");
        log.info(" ------------------------------------------------------------------------");
        log.info("Executing:\n" + String.join((CharSequence)" ", command));
        log.info("");
        processBuilder.command(command);
        try {
            String line;
            Process process = processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            LogLevel currentLogLevel = LogLevel.UNKNOWN;
            block8: while ((line = inputReader.readLine()) != null) {
                Optional<LogLevel> detectedLogLevel = LogLevel.of(line);
                if (detectedLogLevel.isPresent()) {
                    currentLogLevel = detectedLogLevel.get();
                }
                switch (currentLogLevel) {
                    case ERROR: {
                        log.error(currentLogLevel.clean(line));
                        continue block8;
                    }
                    case WARNING: {
                        log.warn(currentLogLevel.clean(line));
                        continue block8;
                    }
                    case INFO: {
                        log.info(currentLogLevel.clean(line));
                        continue block8;
                    }
                }
                log.info(line);
            }
            while ((line = errorReader.readLine()) != null) {
                log.error(line);
            }
            log.info("");
            log.info("");
            log.info("");
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new QuarkusUpdateExitErrorException("The command to update the project exited with an error, see the execution logs above for more details");
            }
        }
        catch (QuarkusUpdateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuarkusUpdateException("Error while executing the command to update the project, see the execution logs above for more details", e);
        }
    }

    static String findMvnBinary(Path baseDir) {
        Path mavenCmd = QuarkusUpdateCommand.findWrapperOrBinary(baseDir, "mvnw", "mvn");
        if (mavenCmd == null) {
            throw new QuarkusUpdateException("Cannot locate mvnw or mvn. Make sure mvnw is in the project directory or mvn is in your PATH.");
        }
        return mavenCmd.toString();
    }

    static String findGradleBinary(Path baseDir) {
        Path gradleCmd = QuarkusUpdateCommand.findWrapperOrBinary(baseDir, "gradlew", "gradle");
        if (gradleCmd == null) {
            throw new QuarkusUpdateException("Cannot gradlew mvnw or gradle. Make sure gradlew is in the current directory or gradle in your PATH.");
        }
        return gradleCmd.toString();
    }

    private static Path findWrapperOrBinary(Path baseDir, String wrapper, String cmd) {
        Path found = QuarkusUpdateCommand.searchPath(wrapper, baseDir.toString());
        if (found == null) {
            found = QuarkusUpdateCommand.searchPath(cmd);
        }
        return found;
    }

    public static Path searchPath(String cmd) {
        String envPath = System.getenv("PATH");
        envPath = envPath != null ? envPath : "";
        return QuarkusUpdateCommand.searchPath(cmd, envPath);
    }

    public static Path searchPath(String cmd, String paths) {
        return Arrays.stream(paths.split(File.pathSeparator)).map(dir -> Paths.get(dir, new String[0]).resolve(cmd)).flatMap(QuarkusUpdateCommand::executables).filter(QuarkusUpdateCommand::isExecutable).findFirst().orElse(null);
    }

    private static Stream<Path> executables(Path base) {
        if (QuarkusUpdateCommand.isWindows()) {
            return Stream.of(Paths.get(base.toString() + ".exe", new String[0]), Paths.get(base.toString() + ".bat", new String[0]), Paths.get(base.toString() + ".cmd", new String[0]), Paths.get(base.toString() + ".ps1", new String[0]));
        }
        return Stream.of(base);
    }

    private static boolean isExecutable(Path file) {
        if (Files.isRegularFile(file, new LinkOption[0])) {
            if (QuarkusUpdateCommand.isWindows()) {
                String nm = file.getFileName().toString().toLowerCase();
                return nm.endsWith(".exe") || nm.endsWith(".bat") || nm.endsWith(".cmd") || nm.endsWith(".ps1");
            }
            return Files.isExecutable(file);
        }
        return false;
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    static boolean hasGradle(Path dir) {
        return Files.exists(dir.resolve("build.gradle"), new LinkOption[0]);
    }

    private static boolean hasMaven(Path dir) {
        return Files.exists(dir.resolve("pom.xml"), new LinkOption[0]);
    }

    private static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        UNKNOWN;

        private static final Pattern LEVEL_PATTERN;

        private static Optional<LogLevel> of(String line) {
            if (line == null || line.isBlank()) {
                return Optional.empty();
            }
            for (LogLevel level : LogLevel.values()) {
                if (!level.matches(line)) continue;
                return Optional.of(level);
            }
            if (LEVEL_PATTERN.matcher(line).matches()) {
                return Optional.of(UNKNOWN);
            }
            return Optional.empty();
        }

        private String clean(String line) {
            if (line == null || line.isBlank()) {
                return line;
            }
            String pattern = "[" + this.name() + "]";
            if (line.length() < pattern.length()) {
                return line;
            }
            return line.substring(pattern.length()).trim();
        }

        private boolean matches(String line) {
            return line != null && line.startsWith("[" + this.name() + "]");
        }

        static {
            LEVEL_PATTERN = Pattern.compile("^\\[[A-Z]+\\].*");
        }
    }
}

