/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.catalog.json.JsonEntityWithAnySupport;
import io.quarkus.registry.catalog.json.JsonPlatformStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class JsonPlatform
extends JsonEntityWithAnySupport
implements Platform {
    private String platformKey;
    private String name;
    private Map<String, PlatformStream> streams;

    @Override
    public String getPlatformKey() {
        return this.platformKey;
    }

    public void setPlatformKey(String platformKey) {
        this.platformKey = platformKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonDeserialize(contentAs=JsonPlatformStream.class)
    public Collection<PlatformStream> getStreams() {
        return this.streams == null ? Collections.emptyList() : this.streams.values();
    }

    @Override
    @JsonIgnore
    public PlatformStream getStream(String id) {
        return this.streams == null ? null : this.streams.get(id);
    }

    public void setStreams(List<PlatformStream> streams) {
        for (PlatformStream s : streams) {
            this.addStream(s);
        }
    }

    public void addStream(PlatformStream stream) {
        if (this.streams == null) {
            this.streams = new LinkedHashMap<String, PlatformStream>();
        }
        this.streams.put(stream.getId(), stream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPlatform that = (JsonPlatform)o;
        return Objects.equals(this.platformKey, that.platformKey);
    }

    public int hashCode() {
        return Objects.hash(this.platformKey);
    }

    public String toString() {
        return this.platformKey + this.streams;
    }
}

