/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.classpath.ClassPathResource;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.jboss.logging.Logger;

public final class QuarkusPathLocationScanner
implements ResourceAndClassScanner {
    private static final Logger LOGGER = Logger.getLogger(QuarkusPathLocationScanner.class);
    private static final String LOCATION_SEPARATOR = "/";
    private static Collection<String> applicationMigrationFiles = Collections.emptyList();
    private static Collection<Class<? extends JavaMigration>> applicationMigrationClasses = Collections.emptyList();
    private final Collection<LoadableResource> scannedResources;

    public QuarkusPathLocationScanner(Collection<Location> locations) {
        LOGGER.debugv("Locations: {0}", locations);
        this.scannedResources = new ArrayList<LoadableResource>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String migrationFile : applicationMigrationFiles) {
            if (!this.canHandleMigrationFile(locations, migrationFile)) continue;
            LOGGER.debugf("Loading %s", (Object)migrationFile);
            this.scannedResources.add((LoadableResource)new ClassPathResource(null, migrationFile, classLoader, StandardCharsets.UTF_8));
        }
    }

    public Collection<LoadableResource> scanForResources() {
        return this.scannedResources;
    }

    private boolean canHandleMigrationFile(Collection<Location> locations, String migrationFile) {
        for (Location location : locations) {
            String locationPath = location.getPath();
            if (!locationPath.endsWith(LOCATION_SEPARATOR)) {
                locationPath = locationPath + LOCATION_SEPARATOR;
            }
            if (migrationFile.startsWith(locationPath)) {
                return true;
            }
            LOGGER.debugf("Migration file '%s' will be ignored because it does not start with '%s'", (Object)migrationFile, (Object)locationPath);
        }
        return false;
    }

    public Collection<Class<? extends JavaMigration>> scanForClasses() {
        return applicationMigrationClasses;
    }

    public static void setApplicationMigrationFiles(Collection<String> applicationMigrationFiles) {
        QuarkusPathLocationScanner.applicationMigrationFiles = applicationMigrationFiles;
    }

    public static void setApplicationMigrationClasses(Collection<Class<? extends JavaMigration>> applicationMigrationClasses) {
        QuarkusPathLocationScanner.applicationMigrationClasses = applicationMigrationClasses;
    }
}

