/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.query;

import io.quarkus.funqy.runtime.query.BaseObjectReader;
import io.quarkus.funqy.runtime.query.QueryObjectMapper;
import io.quarkus.funqy.runtime.query.QueryPropertySetter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

class QueryObjectReader
extends BaseObjectReader {
    Map<String, BaseObjectReader.ValueSetter> properties = new HashMap<String, BaseObjectReader.ValueSetter>();
    Class clz;

    @Override
    public Object create() {
        try {
            return this.clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    QueryObjectReader(Class clz, final QueryObjectMapper mapper) {
        this.clz = clz;
        for (final Method m : clz.getMethods()) {
            if (!QueryObjectReader.isSetter(m)) continue;
            final Class<?> paramType = m.getParameterTypes()[0];
            final Type paramGenericType = m.getGenericParameterTypes()[0];
            final Function<String, Object> extractor = mapper.extractor(paramType);
            Object name = m.getName().length() > 4 ? Character.toLowerCase(m.getName().charAt(3)) + m.getName().substring(4) : m.getName().substring(3).toLowerCase();
            BaseObjectReader.ValueSetter setter = new BaseObjectReader.ValueSetter(){

                @Override
                public void setValue(Object target, String propName, Object value) {
                    try {
                        m.invoke(target, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Function<String, Object> getExtractor() {
                    return extractor;
                }

                @Override
                public QueryPropertySetter getSetter() {
                    if (extractor == null) {
                        return mapper.setterFor(paramType, paramGenericType);
                    }
                    return null;
                }
            };
            this.properties.put((String)name, setter);
        }
    }

    static boolean isSetter(Method m) {
        return !Modifier.isStatic(m.getModifiers()) && m.getName().startsWith("set") && m.getName().length() > "set".length() && m.getParameterCount() == 1;
    }

    @Override
    BaseObjectReader.ValueSetter getValueSetter(String propName) {
        return this.properties.get(propName);
    }
}

