/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.ModifierVisitor;
import com.github.javaparser.ast.visitor.Visitable;
import com.github.javaparser.utils.SourceRoot;
import io.quarkus.deployment.CodeGenContext;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public class GrpcPostProcessing {
    private static final Logger log = Logger.getLogger(GrpcPostProcessing.class);
    private static final String POST_PROCESS_QUARKUS_GENERATED_ANNOTATION = "quarkus.generate-code.grpc-post-processing.use-quarkus-generated-annotation";
    private static final String POST_PROCESS_NO_FINAL = "quarkus.generate-code.grpc-post-processing.no-final";
    public static final String JAVAX_GENERATED = "javax.annotation.Generated";
    public static final String QUARKUS_GENERATED = "io.quarkus.grpc.common.Generated";
    public static final String STUB = "Stub";
    public static final String BIND_METHOD = "bindService";
    private final CodeGenContext context;
    private final Path root;

    public GrpcPostProcessing(CodeGenContext context, Path root) {
        this.context = context;
        this.root = root;
    }

    private boolean isEnabled(String name, boolean def) {
        return Boolean.getBoolean(name) || this.context.config().getOptionalValue(name, Boolean.class).orElse(def) != false;
    }

    public void postprocess() {
        SourceRoot sr = new SourceRoot(this.root);
        try {
            List results = sr.tryToParse();
            for (ParseResult result : results) {
                if (result.isSuccessful()) {
                    CompilationUnit unit = (CompilationUnit)result.getResult().orElseThrow();
                    CompilationUnit.Storage storage = (CompilationUnit.Storage)unit.getStorage().orElseThrow();
                    if (unit.getPrimaryType().isPresent()) {
                        TypeDeclaration type = (TypeDeclaration)unit.getPrimaryType().get();
                        this.postprocess(unit, type, this.context.config());
                    }
                    Files.write(storage.getPath(), List.of(unit.toString()), StandardCharsets.UTF_8, new OpenOption[0]);
                    continue;
                }
                log.errorf("Unable to parse a class generated using protoc, skipping post-processing for this file. Reported problems are %s", (Object)result.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to parse the classes generated using protoc - skipping gRPC post processing", (Throwable)e);
        }
    }

    private void postprocess(CompilationUnit unit, TypeDeclaration<?> primary, Config config) {
        log.debugf("Post-processing %s", (Object)primary.getFullyQualifiedName().orElse(primary.getNameAsString()));
        unit.accept((GenericVisitor)new ModifierVisitor<Void>(){

            public Visitable visit(NormalAnnotationExpr n, Void arg) {
                if (GrpcPostProcessing.this.isEnabled(GrpcPostProcessing.POST_PROCESS_QUARKUS_GENERATED_ANNOTATION, true) && n.getNameAsString().equals(GrpcPostProcessing.JAVAX_GENERATED)) {
                    n.setName(GrpcPostProcessing.QUARKUS_GENERATED);
                }
                return super.visit(n, (Object)arg);
            }

            public Visitable visit(ClassOrInterfaceDeclaration n, Void arg) {
                if (GrpcPostProcessing.this.isEnabled(GrpcPostProcessing.POST_PROCESS_NO_FINAL, true) && n.hasModifier(Modifier.Keyword.FINAL) && n.getNameAsString().endsWith(GrpcPostProcessing.STUB)) {
                    n.removeModifier(new Modifier.Keyword[]{Modifier.Keyword.FINAL});
                }
                return super.visit(n, (Object)arg);
            }

            public Visitable visit(MethodDeclaration n, Void arg) {
                if (GrpcPostProcessing.this.isEnabled(GrpcPostProcessing.POST_PROCESS_NO_FINAL, true) && n.hasModifier(Modifier.Keyword.FINAL) && n.getNameAsString().equalsIgnoreCase(GrpcPostProcessing.BIND_METHOD)) {
                    n.removeModifier(new Modifier.Keyword[]{Modifier.Keyword.FINAL});
                }
                return super.visit(n, (Object)arg);
            }
        }, null);
    }
}

