/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;

class ResourceRegistrationUtils {
    static void registerResourcesForProperties(Config config, BuildProducer<NativeImageResourceBuildItem> resourceBuildItem, Pattern ... patterns) {
        for (String propertyName : config.getPropertyNames()) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(propertyName).matches()) continue;
                String maybeResource = (String)config.getValue(propertyName, String.class);
                ResourceRegistrationUtils.registerResourceForProperty(resourceBuildItem, maybeResource);
            }
        }
    }

    static void registerResourceForProperty(BuildProducer<NativeImageResourceBuildItem> resourceBuildItem, String maybeResource) {
        if (ResourceRegistrationUtils.isOnClassPath(maybeResource)) {
            resourceBuildItem.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{maybeResource}));
        }
    }

    private static boolean isOnClassPath(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path) != null;
    }

    private ResourceRegistrationUtils() {
    }
}

