/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.devmode;

import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.testing.GrpcWebSocketProxy;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import org.jboss.logging.Logger;

@Recorder
public class GrpcDevConsoleRecorder {
    private static final Logger LOG = Logger.getLogger(GrpcDevConsoleRecorder.class);

    public void setServerConfiguration(HttpConfiguration httpConfiguration, GrpcConfiguration grpcConfiguration) {
        GrpcServerConfiguration serverConfig = grpcConfiguration.server;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (serverConfig.useSeparateServer) {
            map.put("host", serverConfig.host);
            map.put("port", serverConfig.port);
            map.put("ssl", serverConfig.ssl.certificate.isPresent() || serverConfig.ssl.keyStore.isPresent());
        } else {
            map.put("host", httpConfiguration.host);
            map.put("port", httpConfiguration.port);
            map.put("ssl", httpConfiguration.insecureRequests != HttpConfiguration.InsecureRequests.ENABLED);
        }
        DevConsoleManager.setGlobal((String)"io.quarkus.grpc.serverConfig", map);
    }

    public Handler<RoutingContext> handler() {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext context) {
                context.request().toWebSocket(webSocket -> {
                    if (webSocket.failed()) {
                        LOG.error((Object)"failed to connect web socket", webSocket.cause());
                    } else {
                        ServerWebSocket serverWebSocket = (ServerWebSocket)webSocket.result();
                        final Integer socketId = GrpcWebSocketProxy.addWebSocket(message -> serverWebSocket.writeTextMessage(message).onFailure(e -> LOG.info((Object)"failed to send back message to the gRPC Dev Console WebSocket", e)), runnable -> {
                            if (!serverWebSocket.isClosed()) {
                                serverWebSocket.close((Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> event) {
                                        runnable.run();
                                    }
                                });
                            } else {
                                runnable.run();
                            }
                        });
                        if (socketId == null) {
                            LOG.error((Object)"No gRPC dev console WebSocketListener");
                            serverWebSocket.close();
                            return;
                        }
                        serverWebSocket.closeHandler(ignored -> GrpcWebSocketProxy.closeWebSocket((int)socketId));
                        serverWebSocket.handler((Handler)new Handler<Buffer>(){

                            public void handle(Buffer event) {
                                GrpcWebSocketProxy.addMessage((Integer)socketId, (String)event.toString());
                            }
                        });
                    }
                });
            }
        };
    }
}

