/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.blocking;

import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.grpc.runtime.supports.blocking.BlockingExecutionHandler;
import io.quarkus.grpc.runtime.supports.blocking.DevModeBlockingExecutionHandler;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlockingServerInterceptor
implements ServerInterceptor,
Function<String, Boolean> {
    private final Vertx vertx;
    private final Set<String> blockingMethods;
    private final Map<String, Boolean> cache = new ConcurrentHashMap<String, Boolean>();
    private final boolean devMode;

    public BlockingServerInterceptor(Vertx vertx, List<String> blockingMethods, boolean devMode) {
        this.vertx = vertx;
        this.blockingMethods = new HashSet<String>();
        this.devMode = devMode;
        for (String method : blockingMethods) {
            this.blockingMethods.add(method.toLowerCase());
        }
    }

    @Override
    public Boolean apply(String name) {
        String methodName = name.substring(name.lastIndexOf("/") + 1);
        return this.blockingMethods.contains(methodName.toLowerCase());
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        boolean isBlocking = this.cache.computeIfAbsent(fullMethodName, this);
        if (isBlocking) {
            ManagedContext requestContext = this.getRequestContext();
            InjectableContext.ContextState state = requestContext.getState();
            ReplayListener replay = new ReplayListener(state);
            this.vertx.executeBlocking(f -> {
                ServerCall.Listener listener;
                try {
                    requestContext.activate(state);
                    listener = next.startCall(call, headers);
                }
                finally {
                    requestContext.deactivate();
                }
                f.complete((Object)listener);
            }, false, event -> replay.setDelegate((ServerCall.Listener)event.result()));
            return replay;
        }
        return next.startCall(call, headers);
    }

    protected ManagedContext getRequestContext() {
        return Arc.container().requestContext();
    }

    private class ReplayListener<ReqT>
    extends ServerCall.Listener<ReqT> {
        private final InjectableContext.ContextState requestContextState;
        private ServerCall.Listener<ReqT> delegate;
        private final Queue<Consumer<ServerCall.Listener<ReqT>>> incomingEvents = new LinkedList<Consumer<ServerCall.Listener<ReqT>>>();
        private boolean isConsumingFromIncomingEvents = false;

        private ReplayListener(InjectableContext.ContextState requestContextState) {
            this.requestContextState = requestContextState;
        }

        void setDelegate(ServerCall.Listener<ReqT> delegate) {
            Consumer<ServerCall.Listener<ReqT>> consumer;
            this.delegate = delegate;
            if (!this.isConsumingFromIncomingEvents && (consumer = this.incomingEvents.poll()) != null) {
                this.executeBlockingWithRequestContext(consumer);
            }
        }

        private void executeOnContextOrEnqueue(Consumer<ServerCall.Listener<ReqT>> consumer) {
            if (this.delegate != null && !this.isConsumingFromIncomingEvents) {
                this.executeBlockingWithRequestContext(consumer);
            } else {
                this.incomingEvents.add(consumer);
            }
        }

        private void executeBlockingWithRequestContext(Consumer<ServerCall.Listener<ReqT>> consumer) {
            Context grpcContext = Context.current();
            Object blockingHandler = new BlockingExecutionHandler<ReqT>(consumer, grpcContext, this.delegate, this.requestContextState, BlockingServerInterceptor.this.getRequestContext(), (Object)this);
            if (BlockingServerInterceptor.this.devMode) {
                blockingHandler = new DevModeBlockingExecutionHandler(Thread.currentThread().getContextClassLoader(), (Handler<Promise<Object>>)blockingHandler);
            }
            this.isConsumingFromIncomingEvents = true;
            BlockingServerInterceptor.this.vertx.executeBlocking(blockingHandler, false, p -> {
                Consumer<ServerCall.Listener<ReqT>> next = this.incomingEvents.poll();
                if (next != null) {
                    this.executeBlockingWithRequestContext(next);
                } else {
                    this.isConsumingFromIncomingEvents = false;
                }
            });
        }

        public void onMessage(ReqT message) {
            this.executeOnContextOrEnqueue(t -> t.onMessage(message));
        }

        public void onHalfClose() {
            this.executeOnContextOrEnqueue(ServerCall.Listener::onHalfClose);
        }

        public void onCancel() {
            this.executeOnContextOrEnqueue(ServerCall.Listener::onCancel);
        }

        public void onComplete() {
            this.executeOnContextOrEnqueue(ServerCall.Listener::onComplete);
        }

        public void onReady() {
            this.executeOnContextOrEnqueue(ServerCall.Listener::onReady);
        }
    }
}

