/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.devui;

import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.devmode.GrpcServices;
import io.quarkus.vertx.http.runtime.CertificateConfig;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import org.jboss.logging.Logger;

public class GrpcJsonRPCService {
    private static final Logger LOG = Logger.getLogger(GrpcJsonRPCService.class);
    @Inject
    HttpConfiguration httpConfiguration;
    @Inject
    HttpBuildTimeConfig httpBuildTimeConfig;
    @Inject
    GrpcConfiguration grpcConfiguration;
    @Inject
    GrpcServices grpcServices;
    private String host;
    private int port;
    private boolean ssl;

    @PostConstruct
    public void init() {
        GrpcServerConfiguration serverConfig = this.grpcConfiguration.server;
        if (serverConfig.useSeparateServer) {
            this.host = serverConfig.host;
            this.port = serverConfig.port;
            this.ssl = serverConfig.ssl.certificate.isPresent() || serverConfig.ssl.keyStore.isPresent();
        } else {
            this.host = this.httpConfiguration.host;
            this.port = this.httpConfiguration.port;
            this.ssl = this.isTLSConfigured(this.httpConfiguration.ssl.certificate);
        }
    }

    private boolean isTLSConfigured(CertificateConfig certificate) {
        return certificate.files.isPresent() || certificate.keyFiles.isPresent() || certificate.keyStoreFile.isPresent();
    }

    public JsonArray getServices() {
        JsonArray services = new JsonArray();
        List<GrpcServices.ServiceDefinitionAndStatus> infos = this.grpcServices.getInfos();
        for (GrpcServices.ServiceDefinitionAndStatus info : infos) {
            JsonObject service = new JsonObject();
            service.put("status", (Object)info.status);
            service.put("name", (Object)info.getName());
            service.put("serviceClass", (Object)info.getServiceClass());
            service.put("hasTestableMethod", (Object)info.hasTestableMethod());
            JsonArray methods = new JsonArray();
            for (GrpcServices.MethodAndPrototype methodAndPrototype : info.getMethodsWithPrototypes()) {
                JsonObject method = new JsonObject();
                method.put("bareMethodName", (Object)methodAndPrototype.getBareMethodName());
                method.put("type", (Object)methodAndPrototype.getType());
                method.put("prototype", (Object)methodAndPrototype.getPrototype());
                method.put("isTestable", (Object)methodAndPrototype.isTestable());
                methods.add((Object)method);
            }
            service.put("methods", (Object)methods);
            services.add((Object)service);
        }
        return services;
    }

    public Uni<String> testService(String serviceName, String methodName, String methodType, String content) {
        try {
            return this.streamService(serviceName, methodName, methodType, content).toUni();
        }
        catch (Throwable t) {
            return Uni.createFrom().item((Object)this.error(t.getMessage()).encodePrettily());
        }
    }

    public Multi<String> streamService(String serviceName, String methodName, String methodType, String content) {
        if (content == null) {
            return Multi.createFrom().item((Object)this.error("Invalid messsge").encodePrettily());
        }
        Map<String, String> params = this.createParams(serviceName, methodName, methodType, content);
        Flow.Publisher publisher = (Flow.Publisher)DevConsoleManager.invoke((String)"grpc-action", params);
        return Multi.createFrom().publisher(publisher);
    }

    private JsonObject error(String message) {
        LOG.error((Object)message);
        JsonObject error = new JsonObject();
        error.put("status", (Object)"ERROR");
        error.put("message", (Object)message);
        return error;
    }

    private Map<String, String> createParams(String serviceName, String methodName, String methodType, String content) {
        return Map.of("serviceName", serviceName, "methodName", methodName, "methodType", methodType, "content", content, "host", this.host, "port", String.valueOf(this.port), "ssl", String.valueOf(this.ssl));
    }
}

