/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.stork;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Deadline;
import io.grpc.MethodDescriptor;
import io.grpc.internal.DelayedClientCall;
import io.quarkus.grpc.runtime.config.StorkConfig;
import io.quarkus.grpc.runtime.stork.StorkMeasuringCollector;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.Stork;
import io.smallrye.stork.api.Service;
import io.smallrye.stork.api.ServiceInstance;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClient;
import io.vertx.grpc.client.GrpcClientChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorkGrpcChannel
extends Channel
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StorkGrpcChannel.class);
    private final Map<Long, ServiceInstance> services = new ConcurrentHashMap<Long, ServiceInstance>();
    private final Map<Long, Channel> channels = new ConcurrentHashMap<Long, Channel>();
    private final ScheduledExecutorService scheduler;
    private final GrpcClient client;
    private final String serviceName;
    private final StorkConfig stork;
    private final Executor executor;

    public StorkGrpcChannel(GrpcClient client, String serviceName, StorkConfig stork, Executor executor) {
        this.client = client;
        this.serviceName = serviceName;
        this.stork = stork;
        this.executor = executor;
        this.scheduler = new ScheduledThreadPoolExecutor(stork.threads);
        this.scheduler.scheduleAtFixedRate(this::refresh, stork.delay, stork.period, TimeUnit.SECONDS);
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        Service service = Stork.getInstance().getService(this.serviceName);
        if (service == null) {
            throw new IllegalStateException("No service definition for serviceName " + this.serviceName + " found.");
        }
        Context context = new Context();
        context.service = service;
        Boolean measureTime = (Boolean)StorkMeasuringCollector.STORK_MEASURE_TIME.get();
        context.measureTime = measureTime != null && measureTime != false;
        context.ref = (AtomicReference)StorkMeasuringCollector.STORK_SERVICE_INSTANCE.get();
        StorkDelayedClientCall delayed = new StorkDelayedClientCall(this.executor, this.scheduler, Deadline.after((long)this.stork.deadline, (TimeUnit)TimeUnit.MILLISECONDS));
        ((CompletableFuture)((CompletableFuture)this.asyncCall(methodDescriptor, callOptions, context).onFailure().retry().atMost((long)this.stork.retries).subscribe().asCompletionStage().thenApply(arg_0 -> delayed.setCall(arg_0))).thenAccept(Runnable::run)).exceptionally(t -> {
            delayed.cancel("Failed to create new Stork ClientCall", (Throwable)t);
            return null;
        });
        return delayed;
    }

    private <RequestT, ResponseT> Uni<ClientCall<RequestT, ResponseT>> asyncCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions, Context context) {
        Uni<Context> entry = this.pickServiceInstanceWithChannel(context);
        return entry.map(c -> {
            ServiceInstance instance = c.instance;
            long serviceId = instance.getId();
            Channel channel = c.channel;
            try {
                this.services.put(serviceId, instance);
                this.channels.put(serviceId, channel);
                return channel.newCall(methodDescriptor, callOptions);
            }
            catch (Exception ex) {
                this.services.remove(serviceId);
                this.channels.remove(serviceId);
                throw new IllegalStateException(ex);
            }
        });
    }

    public String authority() {
        return null;
    }

    @Override
    public void close() {
        this.scheduler.shutdown();
    }

    public String toString() {
        return super.toString() + String.format(" [%s]", this.serviceName);
    }

    private void refresh() {
        this.services.clear();
        this.channels.clear();
    }

    private Uni<Context> pickServiceInstanceWithChannel(Context context) {
        Uni<ServiceInstance> uni = this.pickServerInstance(context.service, context.measureTime);
        return uni.map(si -> {
            context.instance = si;
            if (si.gatherStatistics() && context.ref != null) {
                context.ref.set((ServiceInstance)si);
            }
            return context;
        }).invoke(this::checkSocketAddress).invoke(c -> {
            ServiceInstance instance = context.instance;
            InetSocketAddress isa = context.address;
            context.channel = this.channels.computeIfAbsent(instance.getId(), id -> {
                SocketAddress address = SocketAddress.inetSocketAddress((int)isa.getPort(), (String)isa.getHostName());
                return new GrpcClientChannel(this.client, address);
            });
        });
    }

    private Uni<ServiceInstance> pickServerInstance(Service service, boolean measureTime) {
        return Uni.createFrom().deferred(() -> {
            if (this.services.isEmpty()) {
                return service.getInstances().invoke(l -> l.forEach(s -> this.services.put(s.getId(), (ServiceInstance)s)));
            }
            ArrayList<ServiceInstance> list = new ArrayList<ServiceInstance>(this.services.values());
            return Uni.createFrom().item(list);
        }).map(ArrayList::new).invoke(list -> list.sort(Comparator.comparing(ServiceInstance::getId))).map(list -> service.selectInstanceAndRecordStart((Collection)list, measureTime));
    }

    private void checkSocketAddress(Context context) {
        ServiceInstance instance = context.instance;
        HashSet<InetSocketAddress> socketAddresses = new HashSet<InetSocketAddress>();
        try {
            for (InetAddress inetAddress : InetAddress.getAllByName(instance.getHost())) {
                socketAddresses.add(new InetSocketAddress(inetAddress, instance.getPort()));
            }
        }
        catch (UnknownHostException e) {
            log.warn("Ignoring wrong host: '{}' for service name '{}'", new Object[]{instance.getHost(), this.serviceName, e});
        }
        if (socketAddresses.isEmpty()) {
            long serviceId = instance.getId();
            this.services.remove(serviceId);
            this.channels.remove(serviceId);
            throw new IllegalStateException("Failed to determine working socket addresses for service-name: " + this.serviceName);
        }
        context.address = (InetSocketAddress)socketAddresses.iterator().next();
    }

    private static class Context {
        Service service;
        boolean measureTime;
        ServiceInstance instance;
        InetSocketAddress address;
        Channel channel;
        AtomicReference<ServiceInstance> ref;

        private Context() {
        }
    }

    private static class StorkDelayedClientCall<RequestT, ResponseT>
    extends DelayedClientCall<RequestT, ResponseT> {
        public StorkDelayedClientCall(Executor callExecutor, ScheduledExecutorService scheduler, @Nullable Deadline deadline) {
            super(callExecutor, scheduler, deadline);
        }
    }
}

