/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.auth;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.quarkus.grpc.GlobalInterceptor;
import io.quarkus.grpc.auth.AuthExceptionHandlerProvider;
import io.quarkus.grpc.auth.GrpcSecurityMechanism;
import io.quarkus.security.AuthenticationException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.spi.runtime.AuthenticationFailureEvent;
import io.quarkus.security.spi.runtime.AuthenticationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Prioritized;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@GlobalInterceptor
@Singleton
public final class GrpcSecurityInterceptor
implements ServerInterceptor,
Prioritized {
    private static final Logger log = Logger.getLogger(GrpcSecurityInterceptor.class);
    private static final String IDENTITY_KEY = "io.quarkus.grpc.auth.identity";
    private final IdentityProviderManager identityProviderManager;
    private final CurrentIdentityAssociation identityAssociation;
    private final AuthExceptionHandlerProvider exceptionHandlerProvider;
    private final List<GrpcSecurityMechanism> securityMechanisms;
    private final Map<String, List<String>> serviceToBlockingMethods = new HashMap<String, List<String>>();
    private boolean hasBlockingMethods = false;
    private final boolean notUsingSeparateGrpcServer;
    private final SecurityEventHelper<AuthenticationSuccessEvent, AuthenticationFailureEvent> securityEventHelper;

    @Inject
    public GrpcSecurityInterceptor(CurrentIdentityAssociation identityAssociation, IdentityProviderManager identityProviderManager, Instance<GrpcSecurityMechanism> securityMechanisms, Instance<AuthExceptionHandlerProvider> exceptionHandlers, @ConfigProperty(name="quarkus.grpc.server.use-separate-server") boolean usingSeparateGrpcServer, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled, BeanManager beanManager, Event<AuthenticationFailureEvent> authFailureEvent, Event<AuthenticationSuccessEvent> authSuccessEvent) {
        this.securityEventHelper = new SecurityEventHelper(authSuccessEvent, authFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHENTICATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHENTICATION_FAILURE, beanManager, securityEventsEnabled);
        this.identityAssociation = identityAssociation;
        this.identityProviderManager = identityProviderManager;
        this.notUsingSeparateGrpcServer = !usingSeparateGrpcServer;
        AuthExceptionHandlerProvider maxPrioHandlerProvider = null;
        for (AuthExceptionHandlerProvider handler : exceptionHandlers) {
            if (maxPrioHandlerProvider != null && maxPrioHandlerProvider.getPriority() >= handler.getPriority()) continue;
            maxPrioHandlerProvider = handler;
        }
        this.exceptionHandlerProvider = maxPrioHandlerProvider;
        ArrayList<GrpcSecurityMechanism> mechanisms = new ArrayList<GrpcSecurityMechanism>();
        for (GrpcSecurityMechanism securityMechanism : securityMechanisms) {
            mechanisms.add(securityMechanism);
        }
        if (mechanisms.isEmpty()) {
            this.securityMechanisms = null;
        } else {
            mechanisms.sort(Comparator.comparing(GrpcSecurityMechanism::getPriority));
            this.securityMechanisms = mechanisms;
        }
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Context capturedContext;
        boolean identityAssociationNotSet = true;
        if (this.securityMechanisms != null) {
            Exception error = null;
            for (GrpcSecurityMechanism securityMechanism : this.securityMechanisms) {
                if (!securityMechanism.handles(metadata)) continue;
                try {
                    List<String> methods;
                    AuthenticationRequest authenticationRequest = securityMechanism.createAuthenticationRequest(metadata);
                    final Context context = Vertx.currentContext();
                    final boolean onEventLoopThread = Context.isOnEventLoopThread();
                    final boolean isBlockingMethod = this.hasBlockingMethods ? ((methods = this.serviceToBlockingMethods.get(serverCall.getMethodDescriptor().getServiceName())) != null ? methods.contains(serverCall.getMethodDescriptor().getFullMethodName()) : false) : false;
                    if (authenticationRequest == null) continue;
                    Uni auth = this.identityProviderManager.authenticate(authenticationRequest).emitOn(new Executor(){

                        @Override
                        public void execute(final Runnable command) {
                            if (onEventLoopThread && !isBlockingMethod) {
                                context.runOnContext((Handler)new Handler<Void>(){

                                    public void handle(Void event) {
                                        command.run();
                                    }
                                });
                            } else {
                                command.run();
                            }
                        }
                    });
                    if (this.securityEventHelper.fireEventOnSuccess()) {
                        auth = auth.invoke((Consumer)new Consumer<SecurityIdentity>(){

                            @Override
                            public void accept(SecurityIdentity securityIdentity) {
                                GrpcSecurityInterceptor.this.securityEventHelper.fireSuccessEvent((SecurityEvent)new AuthenticationSuccessEvent(securityIdentity, null));
                            }
                        });
                    }
                    if (this.securityEventHelper.fireEventOnFailure()) {
                        auth = auth.onFailure().invoke((Consumer)new Consumer<Throwable>(){

                            @Override
                            public void accept(Throwable throwable) {
                                GrpcSecurityInterceptor.this.securityEventHelper.fireFailureEvent((SecurityEvent)new AuthenticationFailureEvent(throwable, null));
                            }
                        });
                    }
                    this.identityAssociation.setIdentity(auth);
                    error = null;
                    identityAssociationNotSet = false;
                    break;
                }
                catch (Exception e) {
                    error = e;
                    log.warn((Object)"Failed to prepare AuthenticationRequest for a gRPC call", (Throwable)e);
                }
            }
            if (error != null) {
                AuthenticationFailedException authFailedEx = new AuthenticationFailedException("Failed to parse authentication data", error);
                if (this.securityEventHelper.fireEventOnFailure()) {
                    this.securityEventHelper.fireFailureEvent((SecurityEvent)new AuthenticationFailureEvent((Throwable)authFailedEx, null));
                }
                this.identityAssociation.setIdentity(Uni.createFrom().failure((Throwable)authFailedEx));
                identityAssociationNotSet = false;
            }
        }
        if (identityAssociationNotSet && this.notUsingSeparateGrpcServer && (capturedContext = GrpcSecurityInterceptor.getCapturedVertxContext()) != null) {
            if (capturedContext.getLocal((Object)IDENTITY_KEY) != null) {
                this.identityAssociation.setIdentity((SecurityIdentity)capturedContext.getLocal((Object)IDENTITY_KEY));
            } else if (capturedContext.getLocal((Object)"io.quarkus.vertx.http.deferred-identity") != null) {
                Uni identityUni = ((Uni)capturedContext.getLocal((Object)"io.quarkus.vertx.http.deferred-identity")).onFailure((Predicate)new Predicate<Throwable>(){

                    @Override
                    public boolean test(Throwable t) {
                        return !(t instanceof AuthenticationException);
                    }
                }).transform(AuthenticationFailedException::new);
                this.identityAssociation.setIdentity(identityUni);
            }
            identityAssociationNotSet = false;
        }
        if (identityAssociationNotSet) {
            Uni identityUni = this.identityProviderManager.authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE);
            this.identityAssociation.setIdentity(identityUni);
        }
        ServerCall.Listener listener = serverCallHandler.startCall(serverCall, metadata);
        return this.exceptionHandlerProvider.createHandler(listener, serverCall, metadata);
    }

    public int getPriority() {
        return 2147483547;
    }

    void init(Map<String, List<String>> serviceToBlockingMethods) {
        this.serviceToBlockingMethods.putAll(serviceToBlockingMethods);
        this.hasBlockingMethods = true;
    }

    public static void propagateSecurityIdentityWithDuplicatedCtx(RoutingContext event) {
        Context context = GrpcSecurityInterceptor.getCapturedVertxContext();
        if (context != null) {
            User user = event.user();
            if (user instanceof QuarkusHttpUser) {
                QuarkusHttpUser existing = (QuarkusHttpUser)user;
                GrpcSecurityInterceptor.getCapturedVertxContext().putLocal((Object)IDENTITY_KEY, (Object)existing.getSecurityIdentity());
            } else {
                GrpcSecurityInterceptor.getCapturedVertxContext().putLocal((Object)"io.quarkus.vertx.http.deferred-identity", (Object)QuarkusHttpUser.getSecurityIdentity((RoutingContext)event, null));
                event.remove("io.quarkus.vertx.http.auth-failure-handler");
            }
        }
    }

    private static Context getCapturedVertxContext() {
        Context capturedVertxContext = Vertx.currentContext();
        if (capturedVertxContext == null || !VertxContext.isDuplicatedContext((Context)capturedVertxContext) || VertxContextSafetyToggle.isExplicitlyMarkedAsUnsafe((Context)capturedVertxContext)) {
            log.warn((Object)"Unable to prepare request authentication - authentication must run on Vert.x duplicated context");
            return null;
        }
        return capturedVertxContext;
    }
}

