/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports;

import io.grpc.ClientInterceptor;
import io.grpc.stub.AbstractStub;
import io.quarkus.arc.Arc;
import io.quarkus.grpc.runtime.config.GrpcClientConfiguration;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.supports.EventLoopBlockingCheckInterceptor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

@ApplicationScoped
public class GrpcClientConfigProvider {
    @Inject
    GrpcConfiguration config;

    public GrpcClientConfiguration getConfiguration(String name) {
        Map<String, GrpcClientConfiguration> clients = this.config.clients();
        if (clients == null) {
            return null;
        }
        return clients.get(name);
    }

    public GrpcServerConfiguration getServerConfiguration() {
        return this.config.server();
    }

    AbstractStub<?> adjustCallOptions(String serviceName, AbstractStub<?> stub) {
        GrpcClientConfiguration clientConfig;
        GrpcClientConfiguration grpcClientConfiguration = clientConfig = this.config.clients() != null ? this.config.clients().get(serviceName) : null;
        if (clientConfig != null) {
            if (clientConfig.compression().isPresent()) {
                stub = stub.withCompression(clientConfig.compression().get());
            }
            if (clientConfig.deadline().isPresent()) {
                Duration deadline = clientConfig.deadline().get();
                stub = stub.withDeadlineAfter(deadline.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        return stub;
    }

    public static AbstractStub<?> configureStub(String serviceName, AbstractStub<?> stub) {
        return ((GrpcClientConfigProvider)Arc.container().instance(GrpcClientConfigProvider.class, new Annotation[0]).get()).adjustCallOptions(serviceName, stub);
    }

    public static AbstractStub<?> addBlockingClientInterceptor(AbstractStub<?> stub) {
        return stub.withInterceptors(new ClientInterceptor[]{new EventLoopBlockingCheckInterceptor()});
    }

    public static BiFunction<String, AbstractStub<?>, AbstractStub<?>> getStubConfigurator() {
        return GrpcClientConfigProvider::configureStub;
    }
}

