/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.panache.common.runtime.NamedQueryUtil;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public abstract class AbstractJpaOperations<PanacheQueryType> {
    protected abstract PanacheQueryType createPanacheQuery(EntityManager var1, String var2, String var3, Object var4);

    protected abstract List<?> list(PanacheQueryType var1);

    protected abstract Stream<?> stream(PanacheQueryType var1);

    public abstract EntityManager getEntityManager(Class<?> var1);

    public EntityManager getEntityManager(String persistentUnitName) {
        if (persistentUnitName == null || PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistentUnitName)) {
            return (EntityManager)Arc.container().instance(EntityManager.class, new Annotation[0]).get();
        }
        PersistenceUnit.PersistenceUnitLiteral persistenceUnitLiteral = new PersistenceUnit.PersistenceUnitLiteral(persistentUnitName);
        return (EntityManager)Arc.container().instance(EntityManager.class, new Annotation[]{persistenceUnitLiteral}).get();
    }

    public EntityManager getEntityManager() {
        return this.getEntityManager("<default>");
    }

    public void persist(Object entity) {
        EntityManager em = this.getEntityManager(entity.getClass());
        this.persist(em, entity);
    }

    public void persist(EntityManager em, Object entity) {
        if (!em.contains(entity)) {
            em.persist(entity);
        }
    }

    public void persist(Iterable<?> entities) {
        for (Object entity : entities) {
            this.persist(this.getEntityManager(entity.getClass()), entity);
        }
    }

    public void persist(Object firstEntity, Object ... entities) {
        this.persist(firstEntity);
        for (Object entity : entities) {
            this.persist(entity);
        }
    }

    public void persist(Stream<?> entities) {
        entities.forEach(entity -> this.persist(entity));
    }

    public void delete(Object entity) {
        EntityManager em = this.getEntityManager(entity.getClass());
        em.remove(entity);
    }

    public boolean isPersistent(Object entity) {
        return this.getEntityManager(entity.getClass()).contains(entity);
    }

    public void flush(Object entityClass) {
        this.getEntityManager(entityClass.getClass()).flush();
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
    }

    public static Query bindParameters(Query query, Object[] params) {
        if (params == null || params.length == 0) {
            return query;
        }
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        return query;
    }

    public static Query bindParameters(Query query, Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return query;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    public int paramCount(Object[] params) {
        return params != null ? params.length : 0;
    }

    public int paramCount(Map<String, Object> params) {
        return params != null ? params.size() : 0;
    }

    public Object findById(Class<?> entityClass, Object id) {
        return this.getEntityManager(entityClass).find(entityClass, id);
    }

    public Object findById(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return this.getEntityManager(entityClass).find(entityClass, id, lockModeType);
    }

    public Optional<?> findByIdOptional(Class<?> entityClass, Object id) {
        return Optional.ofNullable(this.findById(entityClass, id));
    }

    public Optional<?> findByIdOptional(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return Optional.ofNullable(this.findById(entityClass, id, lockModeType));
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Object ... params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)this.paramCount(params));
        EntityManager em = this.getEntityManager(entityClass);
        if (PanacheJpaUtil.isNamedQuery((String)query)) {
            String namedQuery = query.substring(1);
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(em, query, PanacheJpaUtil.toOrderBy((Sort)sort), params);
        }
        return this.createPanacheQuery(em, findQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String findQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)query, (int)this.paramCount(params));
        EntityManager em = this.getEntityManager(entityClass);
        if (PanacheJpaUtil.isNamedQuery((String)query)) {
            String namedQuery = query.substring(1);
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(em, query, PanacheJpaUtil.toOrderBy((Sort)sort), params);
        }
        return this.createPanacheQuery(em, findQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Parameters params) {
        return this.find(entityClass, query, (Sort)null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.find(entityClass, query, sort, params.map());
    }

    public List<?> list(Class<?> entityClass, String query, Object ... params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, String query, Parameters params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Object ... params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Parameters params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public PanacheQueryType findAll(Class<?> entityClass) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        EntityManager em = this.getEntityManager(entityClass);
        return this.createPanacheQuery(em, query, null, null);
    }

    public PanacheQueryType findAll(Class<?> entityClass, Sort sort) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        EntityManager em = this.getEntityManager(entityClass);
        return this.createPanacheQuery(em, query, PanacheJpaUtil.toOrderBy((Sort)sort), null);
    }

    public List<?> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public List<?> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Stream<?> streamAll(Class<?> entityClass) {
        return this.stream(this.findAll(entityClass));
    }

    public Stream<?> streamAll(Class<?> entityClass, Sort sort) {
        return this.stream(this.findAll(entityClass, sort));
    }

    public long count(Class<?> entityClass) {
        return (Long)this.getEntityManager(entityClass).createQuery("SELECT COUNT(*) FROM " + PanacheJpaUtil.getEntityName(entityClass)).getSingleResult();
    }

    public long count(Class<?> entityClass, String query, Object ... params) {
        return (Long)AbstractJpaOperations.bindParameters(this.getEntityManager(entityClass).createQuery(PanacheJpaUtil.createCountQuery(entityClass, (String)query, (int)this.paramCount(params))), params).getSingleResult();
    }

    public long count(Class<?> entityClass, String query, Map<String, Object> params) {
        return (Long)AbstractJpaOperations.bindParameters(this.getEntityManager(entityClass).createQuery(PanacheJpaUtil.createCountQuery(entityClass, (String)query, (int)this.paramCount(params))), params).getSingleResult();
    }

    public long count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    public boolean exists(Class<?> entityClass) {
        return this.count(entityClass) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Object ... params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public long deleteAll(Class<?> entityClass) {
        return this.getEntityManager(entityClass).createQuery("DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass)).executeUpdate();
    }

    public boolean deleteById(Class<?> entityClass, Object id) {
        Object entity = this.findById(entityClass, id);
        if (entity == null) {
            return false;
        }
        this.getEntityManager(entityClass).remove(entity);
        return true;
    }

    public long delete(Class<?> entityClass, String query, Object ... params) {
        return AbstractJpaOperations.bindParameters(this.getEntityManager(entityClass).createQuery(PanacheJpaUtil.createDeleteQuery(entityClass, (String)query, (int)this.paramCount(params))), params).executeUpdate();
    }

    public long delete(Class<?> entityClass, String query, Map<String, Object> params) {
        return AbstractJpaOperations.bindParameters(this.getEntityManager(entityClass).createQuery(PanacheJpaUtil.createDeleteQuery(entityClass, (String)query, (int)this.paramCount(params))), params).executeUpdate();
    }

    public long delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses: did you forget to annotate your entity with @Entity?");
    }

    public int executeUpdate(String query, Object ... params) {
        Query jpaQuery = this.getEntityManager("<default>").createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public int executeUpdate(String query, Map<String, Object> params) {
        Query jpaQuery = this.getEntityManager("<default>").createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public int executeUpdate(String query, Class<?> entityClass, Object ... params) {
        Query jpaQuery = this.getEntityManager(entityClass).createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public int executeUpdate(String query, Class<?> entityClass, Map<String, Object> params) {
        Query jpaQuery = this.getEntityManager(entityClass).createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public int executeUpdate(Class<?> entityClass, String query, Object ... params) {
        String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)query, (int)this.paramCount(params));
        return this.executeUpdate(updateQuery, entityClass, params);
    }

    public int executeUpdate(Class<?> entityClass, String query, Map<String, Object> params) {
        String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)query, (int)this.paramCount(params));
        return this.executeUpdate(updateQuery, entityClass, params);
    }

    public int update(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public int update(Class<?> entityClass, String query, Parameters params) {
        return this.update(entityClass, query, params.map());
    }

    public int update(Class<?> entityClass, String query, Object ... params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public void setRollbackOnly() {
        try {
            this.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }
}

