/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.dev;

import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.quarkus.hibernate.orm.runtime.dev.HibernateOrmDevController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateOrmDevIntegrator
implements Integrator {
    private static final Map<String, QuarkusPersistenceUnitDescriptor> puDescriptorMap = new ConcurrentHashMap<String, QuarkusPersistenceUnitDescriptor>();

    public static void clearPuMap() {
        puDescriptorMap.clear();
    }

    public static void mapPersistenceUnit(String pu, QuarkusPersistenceUnitDescriptor descriptor) {
        puDescriptorMap.put(pu, descriptor);
    }

    public void integrate(Metadata metadata, BootstrapContext bootstrapContext, SessionFactoryImplementor sessionFactoryImplementor) {
        String name = (String)sessionFactoryImplementor.getProperties().get("hibernate.persistenceUnitName");
        HibernateOrmDevController.get().pushPersistenceUnit(sessionFactoryImplementor, puDescriptorMap.get(name), name, metadata, (ServiceRegistry)sessionFactoryImplementor.getServiceRegistry(), (String)sessionFactoryImplementor.getProperties().get("hibernate.hbm2ddl.import_files"));
    }

    public void disintegrate(SessionFactoryImplementor sessionFactoryImplementor, SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
        HibernateOrmDevController.get().clearData();
    }
}

