/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.graal;

import java.util.HashSet;
import java.util.Set;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.hibernate.service.Service;

public class RegisterServicesForReflectionFeature
implements Feature {
    private static final int ANTICIPATED_SERVICES = 100;
    private static final Set<Class<?>> registeredClasses = new HashSet(100);

    public String getDescription() {
        return "Makes methods of reachable Hibernate services accessible through Class#getMethods()";
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        for (Class service : access.reachableSubtypes(Service.class)) {
            if (!registeredClasses.add(service)) continue;
            RuntimeReflection.registerAllMethods((Class)service);
            access.requireAnalysisIteration();
        }
    }
}

