/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitKey;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDescriptor;
import io.smallrye.mutiny.tuples.Tuple2;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class JPAConfig {
    private static final Logger LOGGER = Logger.getLogger((String)JPAConfig.class.getName());
    public static final String IS_REACTIVE_KEY = "isReactive";
    private final Map<PersistenceUnitKey, LazyPersistenceUnit> persistenceUnits = new HashMap<PersistenceUnitKey, LazyPersistenceUnit>();
    private final Set<String> deactivatedPersistenceUnitNames = new HashSet<String>();
    private final boolean requestScopedSessionEnabled;

    @Inject
    public JPAConfig(HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig) {
        for (Map.Entry<PersistenceUnitKey, QuarkusPersistenceUnitDescriptor> entry : PersistenceUnitsHolder.getPersistenceUnits().entrySet()) {
            QuarkusPersistenceUnitDescriptor descriptor = entry.getValue();
            String puName = descriptor.getName();
            if (descriptor.getProviderHelper().isActive(puName)) {
                this.persistenceUnits.put(entry.getKey(), new LazyPersistenceUnit(puName, descriptor.isReactive()));
                continue;
            }
            this.deactivatedPersistenceUnitNames.add(puName);
        }
        this.requestScopedSessionEnabled = hibernateOrmRuntimeConfig.requestScopedSessionEnabled();
    }

    void startAll() {
        ArrayList start = new ArrayList();
        boolean moreThanOneThread = this.persistenceUnits.size() > 1;
        for (final Map.Entry<PersistenceUnitKey, LazyPersistenceUnit> entry : this.persistenceUnits.entrySet()) {
            final CompletableFuture future = new CompletableFuture();
            start.add(future);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((LazyPersistenceUnit)entry.getValue()).get();
                        future.complete(null);
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                    }
                }
            }, (String)(moreThanOneThread ? "JPA Startup Thread: " + String.valueOf(entry.getKey()) : "JPA Startup Thread")).start();
        }
        for (CompletableFuture completableFuture : start) {
            try {
                completableFuture.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new RuntimeException(e.getCause());
            }
        }
    }

    public List<Tuple2<String, EntityManagerFactory>> getEntityManagerFactories() {
        ArrayList<Tuple2<String, EntityManagerFactory>> allEntityManagerFactories = new ArrayList<Tuple2<String, EntityManagerFactory>>();
        for (LazyPersistenceUnit pu : this.persistenceUnits.values()) {
            allEntityManagerFactories.add((Tuple2<String, EntityManagerFactory>)Tuple2.of((Object)pu.name, (Object)this.getEntityManagerFactory(pu.name, pu.isReactive)));
        }
        return allEntityManagerFactories;
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName, boolean reactive) {
        LazyPersistenceUnit lazyPersistenceUnit = null;
        if (unitName == null) {
            if (this.persistenceUnits.size() == 1) {
                lazyPersistenceUnit = this.persistenceUnits.values().iterator().next();
            }
        } else {
            lazyPersistenceUnit = this.persistenceUnits.get(new PersistenceUnitKey(unitName, reactive));
        }
        if (lazyPersistenceUnit == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to find an EntityManagerFactory for persistence unit '%s'.%s", unitName, this.deactivatedPersistenceUnitNames.contains(unitName) ? " This persistence unit is deactivated and should not have been created." : ""));
        }
        return lazyPersistenceUnit.get();
    }

    public Set<String> getPersistenceUnits() {
        return this.persistenceUnits.keySet().stream().map(k -> k.name()).collect(Collectors.toSet());
    }

    public Set<String> getDeactivatedPersistenceUnitNames() {
        return this.deactivatedPersistenceUnitNames;
    }

    public boolean getRequestScopedSessionEnabled() {
        return this.requestScopedSessionEnabled;
    }

    void shutdown() {
        LOGGER.trace((Object)"Starting to shut down Hibernate ORM persistence units.");
        for (LazyPersistenceUnit factory : this.persistenceUnits.values()) {
            if (factory.isStarted()) {
                try {
                    LOGGER.tracef("Closing Hibernate ORM persistence unit: %s.", (Object)factory.name);
                    factory.close();
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Unable to close the EntityManagerFactory: " + String.valueOf(factory)), (Throwable)e);
                }
                continue;
            }
            LOGGER.tracef("Skipping Hibernate ORM persistence unit, that failed to start: %s.", (Object)factory.name);
        }
        this.persistenceUnits.clear();
        LOGGER.trace((Object)"Finished shutting down Hibernate ORM persistence units.");
    }

    static final class LazyPersistenceUnit {
        private final String name;
        private final boolean isReactive;
        private volatile EntityManagerFactory value;
        private volatile boolean closed = false;

        LazyPersistenceUnit(String name, boolean isReactive) {
            this.name = name;
            this.isReactive = isReactive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EntityManagerFactory get() {
            if (this.value == null) {
                LazyPersistenceUnit lazyPersistenceUnit = this;
                synchronized (lazyPersistenceUnit) {
                    if (this.closed) {
                        throw new IllegalStateException("Persistence unit is closed");
                    }
                    if (this.value == null) {
                        this.value = Persistence.createEntityManagerFactory((String)this.name, Collections.singletonMap(JPAConfig.IS_REACTIVE_KEY, this.isReactive));
                    }
                }
            }
            return this.value;
        }

        public synchronized void close() {
            this.closed = true;
            EntityManagerFactory emf = this.value;
            this.value = null;
            if (emf != null) {
                emf.close();
            }
        }

        boolean isStarted() {
            return !this.closed && this.value != null;
        }
    }
}

