/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SharedStatelessSessionBuilder;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaInsert;

class StatelessSessionLazyDelegator
implements StatelessSession {
    private final Supplier<StatelessSession> delegate;

    public StatelessSessionLazyDelegator(Supplier<StatelessSession> delegate) {
        this.delegate = delegate;
    }

    public void close() {
        this.delegate.get().close();
    }

    public Object insert(Object entity) {
        return this.delegate.get().insert(entity);
    }

    public Object insert(String entityName, Object entity) {
        return this.delegate.get().insert(entityName, entity);
    }

    public void insertMultiple(List<?> entities) {
        this.delegate.get().insertMultiple(entities);
    }

    public void update(Object entity) {
        this.delegate.get().update(entity);
    }

    public void update(String entityName, Object entity) {
        this.delegate.get().update(entityName, entity);
    }

    public void updateMultiple(List<?> entities) {
        this.delegate.get().updateMultiple(entities);
    }

    public void delete(Object entity) {
        this.delegate.get().delete(entity);
    }

    public void delete(String entityName, Object entity) {
        this.delegate.get().delete(entityName, entity);
    }

    public void deleteMultiple(List<?> entities) {
        this.delegate.get().deleteMultiple(entities);
    }

    public Object get(String entityName, Object id) {
        return this.delegate.get().get(entityName, id);
    }

    public <T> T get(Class<T> entityClass, Object id) {
        return (T)this.delegate.get().get(entityClass, id);
    }

    public Object get(String entityName, Object id, LockMode lockMode) {
        return this.delegate.get().get(entityName, id, lockMode);
    }

    public <T> T get(Class<T> entityClass, Object id, LockMode lockMode) {
        return (T)this.delegate.get().get(entityClass, id, lockMode);
    }

    public <T> T get(EntityGraph<T> graph, Object id) {
        return (T)this.delegate.get().get(graph, id);
    }

    public <T> T get(EntityGraph<T> graph, Object id, LockMode lockMode) {
        return (T)this.delegate.get().get(graph, id, lockMode);
    }

    public <T> List<T> getMultiple(Class<T> entityClass, List<?> ids) {
        return this.delegate.get().getMultiple(entityClass, ids);
    }

    public <T> List<T> getMultiple(Class<T> entityClass, List<?> ids, LockMode lockMode) {
        return this.delegate.get().getMultiple(entityClass, ids, lockMode);
    }

    public <T> List<T> getMultiple(EntityGraph<T> entityGraph, List<?> ids) {
        return this.delegate.get().getMultiple(entityGraph, ids);
    }

    public <T> List<T> getMultiple(EntityGraph<T> entityGraph, GraphSemantic graphSemantic, List<?> ids) {
        return this.delegate.get().getMultiple(entityGraph, graphSemantic, ids);
    }

    public Filter enableFilter(String filterName) {
        return this.delegate.get().enableFilter(filterName);
    }

    public Filter getEnabledFilter(String filterName) {
        return this.delegate.get().getEnabledFilter(filterName);
    }

    public void disableFilter(String filterName) {
        this.delegate.get().disableFilter(filterName);
    }

    public void refresh(Object entity) {
        this.delegate.get().refresh(entity);
    }

    public void refresh(String entityName, Object entity) {
        this.delegate.get().refresh(entityName, entity);
    }

    public void refresh(Object entity, LockMode lockMode) {
        this.delegate.get().refresh(entity, lockMode);
    }

    public void refresh(String entityName, Object entity, LockMode lockMode) {
        this.delegate.get().refresh(entityName, entity, lockMode);
    }

    public void fetch(Object association) {
        this.delegate.get().fetch(association);
    }

    public Object getIdentifier(Object entity) {
        return this.delegate.get().getIdentifier(entity);
    }

    public String getTenantIdentifier() {
        return this.delegate.get().getTenantIdentifier();
    }

    public Object getTenantIdentifierValue() {
        return this.delegate.get().getTenantIdentifier();
    }

    public boolean isOpen() {
        return this.delegate.get().isOpen();
    }

    public boolean isConnected() {
        return this.delegate.get().isConnected();
    }

    public Transaction beginTransaction() {
        return this.delegate.get().beginTransaction();
    }

    public Transaction getTransaction() {
        return this.delegate.get().getTransaction();
    }

    public void joinTransaction() {
        this.delegate.get().joinTransaction();
    }

    public boolean isJoinedToTransaction() {
        return this.delegate.get().isJoinedToTransaction();
    }

    public ProcedureCall getNamedProcedureCall(String name) {
        return this.delegate.get().getNamedProcedureCall(name);
    }

    public ProcedureCall createStoredProcedureCall(String procedureName) {
        return this.delegate.get().createStoredProcedureCall(procedureName);
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, Class<?> ... resultClasses) {
        return this.delegate.get().createStoredProcedureCall(procedureName, (Class[])resultClasses);
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        return this.delegate.get().createStoredProcedureCall(procedureName, resultSetMappings);
    }

    public ProcedureCall createNamedStoredProcedureQuery(String name) {
        return this.delegate.get().createNamedStoredProcedureQuery(name);
    }

    public ProcedureCall createStoredProcedureQuery(String procedureName) {
        return this.delegate.get().createStoredProcedureQuery(procedureName);
    }

    public ProcedureCall createStoredProcedureQuery(String procedureName, Class<?> ... resultClasses) {
        return this.delegate.get().createStoredProcedureQuery(procedureName, (Class[])resultClasses);
    }

    public ProcedureCall createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        return this.delegate.get().createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public Integer getJdbcBatchSize() {
        return this.delegate.get().getJdbcBatchSize();
    }

    public void setJdbcBatchSize(Integer jdbcBatchSize) {
        this.delegate.get().setJdbcBatchSize(jdbcBatchSize);
    }

    public HibernateCriteriaBuilder getCriteriaBuilder() {
        return this.delegate.get().getCriteriaBuilder();
    }

    public void doWork(Work work) throws HibernateException {
        this.delegate.get().doWork(work);
    }

    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        return (T)this.delegate.get().doReturningWork(work);
    }

    @Deprecated(since="6.0")
    public Query createQuery(String queryString) {
        return this.delegate.get().createQuery(queryString);
    }

    public <R> Query<R> createQuery(String queryString, Class<R> resultClass) {
        return this.delegate.get().createQuery(queryString, resultClass);
    }

    public <R> Query<R> createQuery(CriteriaQuery<R> criteriaQuery) {
        return this.delegate.get().createQuery(criteriaQuery);
    }

    @Deprecated(since="6.0")
    public Query createQuery(CriteriaUpdate updateQuery) {
        return this.delegate.get().createQuery(updateQuery);
    }

    @Deprecated(since="6.0")
    public Query createQuery(CriteriaDelete deleteQuery) {
        return this.delegate.get().createQuery(deleteQuery);
    }

    public <R> Query<R> createQuery(TypedQueryReference<R> typedQueryReference) {
        return this.delegate.get().createQuery(typedQueryReference);
    }

    @Deprecated(since="6.0")
    public NativeQuery createNativeQuery(String sqlString) {
        return this.delegate.get().createNativeQuery(sqlString);
    }

    public <R> NativeQuery<R> createNativeQuery(String sqlString, Class<R> resultClass) {
        return this.delegate.get().createNativeQuery(sqlString, resultClass);
    }

    public <R> NativeQuery<R> createNativeQuery(String sqlString, Class<R> resultClass, String tableAlias) {
        return this.delegate.get().createNativeQuery(sqlString, resultClass, tableAlias);
    }

    @Deprecated(since="6.0")
    public NativeQuery createNativeQuery(String sqlString, String resultSetMappingName) {
        return this.delegate.get().createNativeQuery(sqlString, resultSetMappingName);
    }

    public <R> NativeQuery<R> createNativeQuery(String sqlString, String resultSetMappingName, Class<R> resultClass) {
        return this.delegate.get().createNativeQuery(sqlString, resultSetMappingName, resultClass);
    }

    public SelectionQuery<?> createSelectionQuery(String hqlString) {
        return this.delegate.get().createSelectionQuery(hqlString);
    }

    public <R> SelectionQuery<R> createSelectionQuery(String hqlString, Class<R> resultType) {
        return this.delegate.get().createSelectionQuery(hqlString, resultType);
    }

    public <R> SelectionQuery<R> createSelectionQuery(CriteriaQuery<R> criteria) {
        return this.delegate.get().createSelectionQuery(criteria);
    }

    public <R> SelectionQuery<R> createSelectionQuery(String hqlString, EntityGraph<R> resultGraph) {
        return this.delegate.get().createSelectionQuery(hqlString, resultGraph);
    }

    public MutationQuery createMutationQuery(String hqlString) {
        return this.delegate.get().createMutationQuery(hqlString);
    }

    public MutationQuery createMutationQuery(CriteriaUpdate updateQuery) {
        return this.delegate.get().createMutationQuery(updateQuery);
    }

    public MutationQuery createMutationQuery(CriteriaDelete deleteQuery) {
        return this.delegate.get().createMutationQuery(deleteQuery);
    }

    public MutationQuery createMutationQuery(JpaCriteriaInsert insert) {
        return this.delegate.get().createMutationQuery(insert);
    }

    public MutationQuery createNativeMutationQuery(String sqlString) {
        return this.delegate.get().createNativeMutationQuery(sqlString);
    }

    @Deprecated(since="6.0")
    public Query createNamedQuery(String name) {
        return this.delegate.get().createNamedQuery(name);
    }

    public <R> Query<R> createNamedQuery(String name, Class<R> resultClass) {
        return this.delegate.get().createNamedQuery(name, resultClass);
    }

    public SelectionQuery<?> createNamedSelectionQuery(String name) {
        return this.delegate.get().createNamedSelectionQuery(name);
    }

    public <R> SelectionQuery<R> createNamedSelectionQuery(String name, Class<R> resultType) {
        return this.delegate.get().createNamedSelectionQuery(name, resultType);
    }

    public MutationQuery createNamedMutationQuery(String name) {
        return this.delegate.get().createNamedMutationQuery(name);
    }

    @Deprecated(since="6.0")
    public Query getNamedQuery(String queryName) {
        return this.delegate.get().getNamedQuery(queryName);
    }

    @Deprecated(since="6.0")
    public NativeQuery getNamedNativeQuery(String name) {
        return this.delegate.get().getNamedNativeQuery(name);
    }

    @Deprecated(since="6.0")
    public NativeQuery getNamedNativeQuery(String name, String resultSetMapping) {
        return this.delegate.get().getNamedNativeQuery(name, resultSetMapping);
    }

    public <T> RootGraph<T> createEntityGraph(Class<T> rootType) {
        return this.delegate.get().createEntityGraph(rootType);
    }

    public RootGraph<?> createEntityGraph(String graphName) {
        return this.delegate.get().createEntityGraph(graphName);
    }

    public <T> RootGraph<T> createEntityGraph(Class<T> rootType, String graphName) {
        return this.delegate.get().createEntityGraph(rootType, graphName);
    }

    public RootGraph<?> getEntityGraph(String graphName) {
        return this.delegate.get().getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.delegate.get().getEntityGraphs(entityClass);
    }

    public SharedSessionBuilder sessionWithOptions() {
        return this.delegate.get().sessionWithOptions();
    }

    public SharedStatelessSessionBuilder statelessWithOptions() {
        return this.delegate.get().statelessWithOptions();
    }

    public void inTransaction(Consumer<? super Transaction> action) {
        this.delegate.get().inTransaction(action);
    }

    public <R> R fromTransaction(Function<? super Transaction, R> action) {
        return (R)this.delegate.get().fromTransaction(action);
    }

    public SessionFactory getFactory() {
        return this.delegate.get().getFactory();
    }

    public void upsert(Object entity) {
        this.delegate.get().upsert(entity);
    }

    public void upsert(String entityName, Object entity) {
        this.delegate.get().upsert(entityName, entity);
    }

    public void upsertMultiple(List<?> entities) {
        this.delegate.get().upsertMultiple(entities);
    }

    public <T> T get(EntityGraph<T> graph, GraphSemantic graphSemantic, Object id) {
        return (T)this.delegate.get().get(graph, graphSemantic, id);
    }

    public <T> T get(EntityGraph<T> graph, GraphSemantic graphSemantic, Object id, LockMode lockMode) {
        return (T)this.delegate.get().get(graph, graphSemantic, id, lockMode);
    }

    public CacheMode getCacheMode() {
        return this.delegate.get().getCacheMode();
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.delegate.get().setCacheMode(cacheMode);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.delegate.get().unwrap(type);
    }
}

