/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.service;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.config.DialectVersions;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.hibernate.HibernateException;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectLogging;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfoSource;
import org.jboss.logging.Logger;

public class QuarkusRuntimeInitDialectFactory
implements DialectFactory {
    private static final Logger LOG = DialectLogging.DIALECT_LOGGER;
    private final String persistenceUnitName;
    private final boolean isFromPersistenceXml;
    private final Dialect dialect;
    private final Optional<String> datasourceName;
    private final DatabaseVersion buildTimeDbVersion;
    private final boolean versionCheckEnabled;
    private boolean triedToRetrieveDbVersion = false;
    private Optional<DatabaseVersion> actualDbVersion = Optional.empty();

    public QuarkusRuntimeInitDialectFactory(String persistenceUnitName, boolean isFromPersistenceXml, Dialect dialect, Optional<String> datasourceName, DatabaseVersion buildTimeDbVersion, boolean versionCheckEnabled) {
        this.persistenceUnitName = persistenceUnitName;
        this.isFromPersistenceXml = isFromPersistenceXml;
        this.dialect = dialect;
        this.datasourceName = datasourceName;
        this.buildTimeDbVersion = buildTimeDbVersion;
        this.versionCheckEnabled = versionCheckEnabled;
    }

    public Dialect buildDialect(Map<String, Object> configValues, DialectResolutionInfoSource resolutionInfoSource) throws HibernateException {
        if (this.versionCheckEnabled && this.actualDbVersion.isEmpty()) {
            this.actualDbVersion = this.retrieveDbVersion(resolutionInfoSource);
        }
        return this.dialect;
    }

    public void checkActualDbVersion() {
        if (!this.versionCheckEnabled) {
            LOG.debugf("Persistence unit %1$s: Skipping database version check; expecting database version to be at least %2$s", (Object)this.persistenceUnitName, (Object)DialectVersions.toString(this.buildTimeDbVersion));
            return;
        }
        if (!this.triedToRetrieveDbVersion) {
            LOG.warnf("Persistence unit %1$s: Could not retrieve the database version to check it is at least %2$s", (Object)this.persistenceUnitName, (Object)DialectVersions.toString(this.buildTimeDbVersion));
            return;
        }
        if (this.actualDbVersion.isPresent() && this.buildTimeDbVersion.isAfter(this.actualDbVersion.get())) {
            StringBuilder errorMessage = new StringBuilder(String.format(Locale.ROOT, "Persistence unit '%1$s' was configured to run with a database version of at least '%2$s', but the actual version is '%3$s'. Consider upgrading your database.", this.persistenceUnitName, DialectVersions.toString(this.buildTimeDbVersion), DialectVersions.toString(this.actualDbVersion.get())));
            if (this.datasourceName.isPresent()) {
                errorMessage.append(String.format(Locale.ROOT, " Alternatively, rebuild your application with '%1$s=%2$s' (but this may disable some features and/or impact performance negatively).", this.isFromPersistenceXml ? "jakarta.persistence.database-product-version" : DataSourceUtil.dataSourcePropertyKey((String)this.datasourceName.get(), (String)"db-version"), DialectVersions.toString(this.actualDbVersion.get())));
            }
            if (!this.isFromPersistenceXml) {
                errorMessage.append(String.format(Locale.ROOT, " As a last resort, if you are certain your application will work correctly even though the database version is incorrect, disable the check with '%1$s=false'.", HibernateOrmRuntimeConfig.puPropertyKey(this.persistenceUnitName, "database.version-check.enabled")));
            }
            throw new ConfigurationException(errorMessage.toString());
        }
    }

    private Optional<DatabaseVersion> retrieveDbVersion(DialectResolutionInfoSource resolutionInfoSource) {
        try {
            DialectResolutionInfo resolutionInfo;
            DialectResolutionInfo dialectResolutionInfo = resolutionInfo = resolutionInfoSource == null ? null : resolutionInfoSource.getDialectResolutionInfo();
            if (resolutionInfo == null) {
                return Optional.empty();
            }
            this.triedToRetrieveDbVersion = true;
            return Optional.of(this.dialect.determineDatabaseVersion(resolutionInfo));
        }
        catch (RuntimeException e) {
            LOG.warnf((Throwable)e, "Persistence unit %1$s: Could not retrieve the database version to check it is at least %2$s", (Object)this.persistenceUnitName, (Object)this.buildTimeDbVersion);
            return Optional.empty();
        }
    }

    public boolean isVersionCheckEnabled() {
        return this.versionCheckEnabled;
    }
}

