/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.recording;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsBuilder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.NamedResultSetMappingDescriptor;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public final class PrevalidatedQuarkusMetadata
implements MetadataImplementor {
    private final MetadataImpl metadata;

    private PrevalidatedQuarkusMetadata(MetadataImpl metadata) {
        this.metadata = metadata;
    }

    public static PrevalidatedQuarkusMetadata validateAndWrap(MetadataImpl original) {
        original.validate();
        original.getBootstrapContext().getReflectionManager().reset();
        return new PrevalidatedQuarkusMetadata(original);
    }

    public SessionFactoryOptionsBuilder buildSessionFactoryOptionsBuilder() {
        SessionFactoryOptionsBuilder builder = new SessionFactoryOptionsBuilder(this.metadata.getMetadataBuildingOptions().getServiceRegistry(), this.metadata.getBootstrapContext());
        Map sqlFunctions = this.metadata.getSqlFunctionMap();
        if (sqlFunctions != null) {
            for (Map.Entry entry : sqlFunctions.entrySet()) {
                builder.applySqlFunction((String)entry.getKey(), (SqmFunctionDescriptor)entry.getValue());
            }
        }
        return builder;
    }

    public SessionFactoryBuilder getSessionFactoryBuilder() {
        throw new IllegalStateException("This method is not supposed to be used in Quarkus");
    }

    public SessionFactory buildSessionFactory() {
        throw new IllegalStateException("This method is not supposed to be used in Quarkus");
    }

    public void validate() throws MappingException {
    }

    public UUID getUUID() {
        return this.metadata.getUUID();
    }

    public Database getDatabase() {
        return this.metadata.getDatabase();
    }

    public Collection<PersistentClass> getEntityBindings() {
        return this.metadata.getEntityBindings();
    }

    public PersistentClass getEntityBinding(String entityName) {
        return this.metadata.getEntityBinding(entityName);
    }

    public Collection<org.hibernate.mapping.Collection> getCollectionBindings() {
        return this.metadata.getCollectionBindings();
    }

    public org.hibernate.mapping.Collection getCollectionBinding(String role) {
        return this.metadata.getCollectionBinding(role);
    }

    public Map<String, String> getImports() {
        return this.metadata.getImports();
    }

    public NamedHqlQueryDefinition getNamedHqlQueryMapping(String name) {
        return this.metadata.getNamedHqlQueryMapping(name);
    }

    public void visitNamedHqlQueryDefinitions(Consumer<NamedHqlQueryDefinition> definitionConsumer) {
        this.metadata.visitNamedHqlQueryDefinitions(definitionConsumer);
    }

    public NamedNativeQueryDefinition getNamedNativeQueryMapping(String name) {
        return this.metadata.getNamedNativeQueryMapping(name);
    }

    public void visitNamedNativeQueryDefinitions(Consumer<NamedNativeQueryDefinition> definitionConsumer) {
        this.metadata.visitNamedNativeQueryDefinitions(definitionConsumer);
    }

    public NamedProcedureCallDefinition getNamedProcedureCallMapping(String name) {
        return this.metadata.getNamedProcedureCallMapping(name);
    }

    public void visitNamedProcedureCallDefinition(Consumer<NamedProcedureCallDefinition> definitionConsumer) {
        this.metadata.visitNamedProcedureCallDefinition(definitionConsumer);
    }

    public NamedResultSetMappingDescriptor getResultSetMapping(String name) {
        return this.metadata.getResultSetMapping(name);
    }

    public void visitNamedResultSetMappingDefinition(Consumer<NamedResultSetMappingDescriptor> definitionConsumer) {
        this.metadata.visitNamedResultSetMappingDefinition(definitionConsumer);
    }

    public TypeDefinition getTypeDefinition(String typeName) {
        return this.metadata.getTypeDefinition(typeName);
    }

    public Map<String, FilterDefinition> getFilterDefinitions() {
        return this.metadata.getFilterDefinitions();
    }

    public FilterDefinition getFilterDefinition(String name) {
        return this.metadata.getFilterDefinition(name);
    }

    public FetchProfile getFetchProfile(String name) {
        return this.metadata.getFetchProfile(name);
    }

    public Collection<FetchProfile> getFetchProfiles() {
        return this.metadata.getFetchProfiles();
    }

    public NamedEntityGraphDefinition getNamedEntityGraph(String name) {
        return this.metadata.getNamedEntityGraph(name);
    }

    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphs() {
        return this.metadata.getNamedEntityGraphs();
    }

    public IdentifierGeneratorDefinition getIdentifierGenerator(String name) {
        return this.metadata.getIdentifierGenerator(name);
    }

    public Collection<Table> collectTableMappings() {
        return this.metadata.collectTableMappings();
    }

    public Map<String, SqmFunctionDescriptor> getSqlFunctionMap() {
        return this.metadata.getSqlFunctionMap();
    }

    public Set<String> getContributors() {
        return this.metadata.getContributors();
    }

    public Type getIdentifierType(String className) throws MappingException {
        return this.metadata.getIdentifierType(className);
    }

    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.metadata.getIdentifierPropertyName(className);
    }

    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.metadata.getReferencedPropertyType(className, propertyName);
    }

    public MetadataBuildingOptions getMetadataBuildingOptions() {
        return this.metadata.getMetadataBuildingOptions();
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.metadata.getTypeConfiguration();
    }

    public SqmFunctionRegistry getFunctionRegistry() {
        return this.metadata.getFunctionRegistry();
    }

    public NamedObjectRepository buildNamedQueryRepository(SessionFactoryImplementor sessionFactory) {
        return this.metadata.buildNamedQueryRepository(sessionFactory);
    }

    public void orderColumns(boolean forceOrdering) {
        this.metadata.orderColumns(forceOrdering);
    }

    public Set<MappedSuperclass> getMappedSuperclassMappingsCopy() {
        return this.metadata.getMappedSuperclassMappingsCopy();
    }

    public void initSessionFactory(SessionFactoryImplementor sessionFactoryImplementor) {
        this.metadata.initSessionFactory(sessionFactoryImplementor);
    }

    public void visitRegisteredComponents(Consumer<Component> consumer) {
        this.metadata.visitRegisteredComponents(consumer);
    }

    public Component getGenericComponent(Class<?> componentClass) {
        return this.metadata.getGenericComponent(componentClass);
    }

    public Map<String, PersistentClass> getEntityBindingMap() {
        return this.metadata.getEntityBindingMap();
    }

    public Map<String, org.hibernate.mapping.Collection> getCollectionBindingMap() {
        return this.metadata.getCollectionBindingMap();
    }

    public Map<String, TypeDefinition> getTypeDefinitionMap() {
        return this.metadata.getTypeDefinitionMap();
    }

    public Map<String, FetchProfile> getFetchProfileMap() {
        return this.metadata.getFetchProfileMap();
    }

    public Map<Class<?>, MappedSuperclass> getMappedSuperclassMap() {
        return this.metadata.getMappedSuperclassMap();
    }

    public Map<String, IdentifierGeneratorDefinition> getIdGeneratorDefinitionMap() {
        return this.metadata.getIdGeneratorDefinitionMap();
    }

    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphMap() {
        return this.metadata.getNamedEntityGraphMap();
    }

    public BootstrapContext getBootstrapContext() {
        return this.metadata.getBootstrapContext();
    }

    public Map<String, NamedHqlQueryDefinition> getNamedQueryMap() {
        return this.metadata.getNamedQueryMap();
    }

    public Map<String, NamedNativeQueryDefinition> getNamedNativeQueryMap() {
        return this.metadata.getNamedNativeQueryMap();
    }

    public Map<String, NamedProcedureCallDefinition> getNamedProcedureCallMap() {
        return this.metadata.getNamedProcedureCallMap();
    }

    public Map<String, NamedResultSetMappingDescriptor> getSqlResultSetMappingMap() {
        return this.metadata.getSqlResultSetMappingMap();
    }

    public List<Component> getComposites() {
        return this.metadata.getComposites();
    }
}

