/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.Unremovable;
import io.vertx.core.Context;
import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.hibernate.reactive.common.spi.MutinyImplementor;
import org.hibernate.reactive.mutiny.Mutiny;

public class ReactiveSessionProducer {
    @Inject
    MutinyImplementor mutinyImplementor;

    @Produces
    @RequestScoped
    @DefaultBean
    @Unremovable
    public Mutiny.Session createMutinySession() {
        return this.mutinyImplementor.newSession();
    }

    public void disposeMutinySession(@Disposes Mutiny.Session reactiveSession) {
        if (reactiveSession != null) {
            CompletableFuture closeOperation = reactiveSession.close().subscribe().asCompletionStage();
            if (!Context.isOnVertxThread()) {
                closeOperation.join();
            }
        }
    }
}

