/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class RuntimeLaunchClassLoader
extends ClassLoader {
    public RuntimeLaunchClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        block9: {
            String resourceName = "META-INF/ide-deps/" + name.replace(".", "/") + ".class.ide-launcher-res";
            InputStream is = this.getParent().getResourceAsStream(resourceName);
            try {
                if (is == null) {
                    throw new ClassNotFoundException(name);
                }
                this.definePackage(name);
                byte[] bytes = is.readAllBytes();
                clazz = this.defineClass(name, bytes, 0, bytes.length);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return clazz;
    }

    private void definePackage(String name) {
        String pkgName = this.getPackageNameFromClassName(name);
        if (pkgName == null) {
            return;
        }
        if (this.getDefinedPackage(pkgName) != null) {
            return;
        }
        try {
            this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException e) {
            if (this.getDefinedPackage(pkgName) != null) {
                return;
            }
            throw e;
        }
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    protected URL findResource(String moduleName, String name) throws IOException {
        return this.findResource(name);
    }

    @Override
    protected URL findResource(String name) {
        if (!((String)name).startsWith("/")) {
            name = "/" + (String)name;
        }
        return this.getParent().getResource("META-INF/ide-deps" + (String)name + ".ide-launcher-res");
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (!((String)name).startsWith("/")) {
            name = "/" + (String)name;
        }
        return this.getParent().getResources("META-INF/ide-deps" + (String)name + ".ide-launcher-res");
    }

    static {
        RuntimeLaunchClassLoader.registerAsParallelCapable();
    }
}

