/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jacoco.runtime;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.LongSupplier;

class DataFileWatch {
    static final int ABORT_TIMEOUT_MILLIS = 10000;
    private final LongSupplier clock;
    private final Path datafile;
    private final long initialDataFileSize;
    private final BooleanSupplier jacocoFinished;
    private final Consumer<String> errorMsg;

    DataFileWatch(Path datafile, BooleanSupplier jacocoFinished, Consumer<String> errorMsg) {
        this(System::currentTimeMillis, datafile, jacocoFinished, errorMsg);
    }

    DataFileWatch(LongSupplier clock, Path datafile, BooleanSupplier jacocoFinished, Consumer<String> errorMsg) {
        this.clock = clock;
        this.datafile = datafile;
        this.jacocoFinished = jacocoFinished;
        this.errorMsg = errorMsg;
        try {
            this.initialDataFileSize = this.dataFileSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean waitForDataFile() throws IOException, InterruptedException {
        long abortTime = this.nextAbortTime();
        long previousFileSize = this.initialDataFileSize;
        while (true) {
            long fileSize;
            if ((fileSize = this.dataFileSize()) != this.initialDataFileSize) {
                if (fileSize != previousFileSize) {
                    abortTime = this.nextAbortTime();
                }
                if (fileSize > 0L && this.jacocoFinished.getAsBoolean()) {
                    return true;
                }
            }
            if (this.timedOut(abortTime)) {
                this.errorMsg.accept("Timed out waiting for Jacoco data file " + String.valueOf(this.datafile) + " update, file size before test run: " + String.valueOf(this.initialDataFileSize != -1L ? Long.valueOf(this.initialDataFileSize) : "did not exist") + ", current file size: " + String.valueOf(fileSize != -1L ? Long.valueOf(fileSize) : "does not exist"));
                return false;
            }
            this.waitSleep();
            previousFileSize = fileSize;
        }
    }

    private boolean timedOut(long abortTime) {
        return abortTime - this.clock.getAsLong() < 0L;
    }

    private long nextAbortTime() {
        return this.clock.getAsLong() + 10000L;
    }

    void waitSleep() throws InterruptedException {
        Thread.sleep(100L);
    }

    long dataFileSize() throws IOException {
        return Files.exists(this.datafile, new LinkOption[0]) ? Files.size(this.datafile) : -1L;
    }
}

