/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jacoco.runtime;

import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.test.component.QuarkusComponentTestCallbacks;
import io.quarkus.test.component.QuarkusComponentTestClassLoader;
import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.Logger;

public class JacocoQuarkusComponentTestCallbacks
implements QuarkusComponentTestCallbacks {
    private static final Logger LOG = Logger.getLogger(JacocoQuarkusComponentTestCallbacks.class);

    public void beforeBuild(QuarkusComponentTestCallbacks.BeforeBuildContext beforeBuild) {
        List<ClassInfo> toTransform = beforeBuild.getImmutableBeanArchiveIndex().getKnownClasses().stream().filter(c -> !QuarkusComponentTestClassLoader.mustDelegateToParent((String)c.name().toString())).toList();
        final Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
        for (ClassInfo clazz : toTransform) {
            beforeBuild.addBytecodeTransformer(BytecodeTransformer.forInputTransformer((String)clazz.name().toString(), (BiFunction)new BiFunction<String, byte[], byte[]>(){

                @Override
                public byte[] apply(String className, byte[] bytes) {
                    try {
                        byte[] enhanced = instrumenter.instrument(bytes, className);
                        if (enhanced == null) {
                            return bytes;
                        }
                        return enhanced;
                    }
                    catch (IOException e) {
                        LOG.warnf((Throwable)e, "Unable to instrument class %s with JaCoCo, keeping the original class", (Object)className);
                        return bytes;
                    }
                }
            }));
        }
    }
}

