/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jfr.runtime.http.rest;

import io.quarkus.arc.Arc;
import io.quarkus.jfr.runtime.http.rest.Recorder;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

@Provider
public class JfrClassicServerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger LOG = Logger.getLogger(JfrClassicServerFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Enter Jfr Classic Request Filter");
        }
        Recorder recorder = (Recorder)Arc.container().instance(Recorder.class, new Annotation[0]).get();
        recorder.recordStartEvent();
        recorder.startPeriodEvent();
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Enter Jfr Classic Response Filter");
        }
        if (this.isRecordable(responseContext)) {
            Recorder recorder = (Recorder)Arc.container().instance(Recorder.class, new Annotation[0]).get();
            recorder.endPeriodEvent();
            recorder.recordEndEvent();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Recording REST event was skipped");
        }
    }

    private boolean isRecordable(ContainerResponseContext responseContext) {
        return responseContext.getStatus() != Response.Status.NOT_FOUND.getStatusCode();
    }
}

