/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.common.TestResourceManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;

public class IntegrationTestExtensionState
implements ExtensionContext.Store.CloseableResource {
    private final TestResourceManager testResourceManager;
    private final Closeable resource;
    private final Map<String, String> sysPropRestore;
    private final Thread shutdownHook;

    IntegrationTestExtensionState(TestResourceManager testResourceManager, Closeable resource, Map<String, String> sysPropRestore) {
        this.testResourceManager = testResourceManager;
        this.resource = resource;
        this.sysPropRestore = sysPropRestore;
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IntegrationTestExtensionState.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, "Quarkus Test Cleanup Shutdown task");
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void close() throws IOException {
        this.testResourceManager.close();
        this.resource.close();
        for (Map.Entry<String, String> entry : this.sysPropRestore.entrySet()) {
            String val = entry.getValue();
            if (val == null) {
                System.clearProperty(entry.getKey());
                continue;
            }
            System.setProperty(entry.getKey(), val);
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    public TestResourceManager getTestResourceManager() {
        return this.testResourceManager;
    }
}

