/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.BootstrapAppModelFactory;
import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.RestorableSystemProperties;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.junit.ClassCoercingTestProfile;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestBuildChainFunction;
import jakarta.enterprise.inject.Alternative;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.jandex.Index;

public class AppMakerHelper {
    protected static final String TEST_LOCATION = "test-location";
    protected static final String TEST_CLASS = "test-class";
    protected static final String TEST_PROFILE = "test-profile";
    private static Class<?> quarkusTestMethodContextClass;
    private static boolean hasPerTestResources;
    private static List<Object> testMethodInvokers;
    private Runnable configCleanup;

    public static ApplicationModel getGradleAppModelForIDE(Path projectRoot) throws IOException, AppModelResolverException {
        return System.getProperty("quarkus-internal-test.serialized-app-model.path") == null ? BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot) : null;
    }

    private PrepareResult createAugmentor(Class<?> requiredTestClass, String displayName, boolean isContinuousTesting, CuratedApplication curatedApplication, Class<? extends QuarkusTestProfile> profile, Collection<Runnable> shutdownTasks) throws AppModelResolverException, BootstrapException, IOException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (curatedApplication == null) {
            curatedApplication = this.makeCuratedApplication(requiredTestClass, displayName, isContinuousTesting, shutdownTasks);
        }
        Path testClassLocation = PathTestHelper.getTestClassesLocation(requiredTestClass, (CuratedApplication)curatedApplication);
        System.clearProperty("test.url");
        HashMap<String, String> additional = new HashMap<String, String>();
        ClassCoercingTestProfile profileInstance = null;
        if (profile != null) {
            profileInstance = new ClassCoercingTestProfile(profile.getConstructor(new Class[0]).newInstance(new Object[0]));
            additional.putAll(profileInstance.getConfigOverrides());
            if (!profileInstance.getEnabledAlternatives().isEmpty()) {
                additional.put("quarkus.arc.selected-alternatives", profileInstance.getEnabledAlternatives().stream().peek(c -> {
                    try {
                        if (!c.isAnnotationPresent(profile.getClassLoader().loadClass(Alternative.class.getName()))) {
                            throw new RuntimeException("Enabled alternative " + String.valueOf(c) + " is not annotated with @Alternative");
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }).map(Class::getName).collect(Collectors.joining(",")));
            }
            if (profileInstance.disableApplicationLifecycleObservers()) {
                additional.put("quarkus.arc.test.disable-application-lifecycle-observers", "true");
            }
            if (profileInstance.getConfigProfile() != null) {
                additional.put(LaunchMode.TEST.getProfileKey(), profileInstance.getConfigProfile());
            }
            this.configCleanup = () -> ((RestorableSystemProperties)RestorableSystemProperties.setProperties(additional, (String[])new String[0])).close();
        }
        if (curatedApplication.getApplicationModel().getRuntimeDependencies().isEmpty()) {
            throw new RuntimeException("The tests were run against a directory that does not contain a Quarkus project. Please ensure that the test is configured to use the proper working directory.");
        }
        Index testClassesIndex = TestClassIndexer.indexTestClasses((Path)testClassLocation);
        TestClassIndexer.writeIndex((Index)testClassesIndex, (Path)testClassLocation, requiredTestClass);
        Timing.staticInitStarted((ClassLoader)curatedApplication.getOrCreateBaseRuntimeClassLoader(), (boolean)curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(TEST_LOCATION, testClassLocation);
        props.put(TEST_CLASS, requiredTestClass);
        if (profile != null) {
            props.put(TEST_PROFILE, profile.getName());
        }
        return new PrepareResult(curatedApplication.createAugmentor(TestBuildChainFunction.class.getName(), props), profileInstance, curatedApplication);
    }

    public CuratedApplication makeCuratedApplication(Class<?> requiredTestClass, String displayName, boolean isContinuousTesting, Collection<Runnable> shutdownTasks) throws IOException, AppModelResolverException, BootstrapException {
        Path testClassLocation;
        PathList.Builder rootBuilder = PathList.builder();
        Consumer<Path> addToBuilderIfConditionMet = path -> {
            if (path != null && !rootBuilder.contains(path) && Files.exists(path, new LinkOption[0])) {
                rootBuilder.add(path);
            }
        };
        Path projectRoot = Path.of("", new String[0]).normalize().toAbsolutePath();
        ApplicationModel testAppModel = null;
        ApplicationModel gradleAppModel = AppMakerHelper.getGradleAppModelForIDE(projectRoot);
        if (gradleAppModel != null && gradleAppModel.getApplicationModule() != null) {
            WorkspaceModule module = gradleAppModel.getApplicationModule();
            String testClassFileName = ClassLoaderHelper.fromClassNameToResourceName((String)requiredTestClass.getName());
            Path testClassesDir = null;
            for (String classifier : module.getSourceClassifiers()) {
                ArtifactSources sources = module.getSources(classifier);
                if (!sources.isOutputAvailable() || !sources.getOutputTree().contains(testClassFileName)) continue;
                for (SourceDir src : sources.getSourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                    if (!Files.exists(src.getOutputDir().resolve(testClassFileName), new LinkOption[0])) continue;
                    testClassesDir = src.getOutputDir();
                }
                for (SourceDir src : sources.getResourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
                for (SourceDir src : module.getMainSources().getSourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
                for (SourceDir src : module.getMainSources().getResourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
            }
            PathTestHelper.validateTestDir(requiredTestClass, testClassesDir, (WorkspaceModule)module);
            testClassLocation = testClassesDir;
        } else {
            Path appClassLocation;
            if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
                String[] sourceDirectories;
                for (String sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                    Path directory = Paths.get(sourceDirectory, new String[0]);
                    addToBuilderIfConditionMet.accept(directory);
                }
            }
            if (!(appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((Path)(testClassLocation = PathTestHelper.getTestClassesLocation(requiredTestClass)))).equals(testClassLocation)) {
                addToBuilderIfConditionMet.accept(testClassLocation);
                Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
                addToBuilderIfConditionMet.accept(testResourcesLocation);
            }
            addToBuilderIfConditionMet.accept(appClassLocation);
            testAppModel = BootstrapAppModelFactory.newInstance().setTest(true).setEnableClasspathCache(true).setProjectRoot(projectRoot).resolveAppModel().getApplicationModel();
            for (Path rootDir : testAppModel.getAppArtifact().getContentTree().getRoots()) {
                addToBuilderIfConditionMet.accept(rootDir);
            }
        }
        CuratedApplication curatedApplication = QuarkusBootstrap.builder().setExistingModel(testAppModel).setBaseName(displayName + " (QuarkusTest)").setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST).setTest(true).setAuxiliaryApplication(isContinuousTesting).setTargetDirectory(PathTestHelper.getProjectBuildDir((Path)projectRoot, (Path)testClassLocation)).setProjectRoot(projectRoot).setApplicationRoot((PathCollection)rootBuilder.build()).build().bootstrap();
        shutdownTasks.add(() -> ((CuratedApplication)curatedApplication).close());
        return curatedApplication;
    }

    public StartupAction getStartupAction(Class testClass, CuratedApplication curatedApplication, boolean isContinuousTesting, Class profile) throws AppModelResolverException, BootstrapException, IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        HashSet<Runnable> shutdownTasks = new HashSet<Runnable>();
        PrepareResult result = this.createAugmentor(testClass, "(QuarkusTest)", isContinuousTesting, curatedApplication, profile, shutdownTasks);
        AugmentAction augmentAction = result.augmentAction;
        try {
            StartupAction startupAction;
            StartupAction startupAction2 = startupAction = augmentAction.createInitialRuntimeApplication();
            return startupAction2;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (this.configCleanup != null) {
                this.configCleanup.run();
            }
        }
    }

    public static class PrepareResult {
        protected final AugmentAction augmentAction;
        public final QuarkusTestProfile profileInstance;
        protected final CuratedApplication curatedApplication;

        public PrepareResult(AugmentAction augmentAction, QuarkusTestProfile profileInstance, CuratedApplication curatedApplication) {
            this.augmentAction = augmentAction;
            this.profileInstance = profileInstance;
            this.curatedApplication = curatedApplication;
        }
    }
}

