/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.deployment;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.kafka.client.deployment.RedPandaBuildTimeConfig;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

final class RedPandaKafkaContainer
extends GenericContainer<RedPandaKafkaContainer> {
    private final Integer fixedExposedPort;
    private final boolean useSharedNetwork;
    private final RedPandaBuildTimeConfig redpandaConfig;
    private String hostName = null;
    private static final String STARTER_SCRIPT = "/var/lib/redpanda/redpanda.sh";

    RedPandaKafkaContainer(DockerImageName dockerImageName, int fixedExposedPort, String serviceName, boolean useSharedNetwork, RedPandaBuildTimeConfig redpandaConfig) {
        super(dockerImageName);
        this.fixedExposedPort = fixedExposedPort;
        this.useSharedNetwork = useSharedNetwork;
        this.redpandaConfig = redpandaConfig;
        if (serviceName != null) {
            this.withLabel("quarkus-dev-service-kafka", serviceName);
        }
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"sh"}));
        this.withCommand(new String[]{"-c", "while [ ! -f /var/lib/redpanda/redpanda.sh ]; do sleep 0.1; done; /var/lib/redpanda/redpanda.sh"});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Started Kafka API server.*", (int)1));
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarting(containerInfo, reused);
        Object command = "#!/bin/bash\n";
        command = (String)command + "/usr/bin/rpk redpanda start --check=false --node-id 0 --smp 1 ";
        command = (String)command + "--memory 1G --overprovisioned --reserve-memory 0M ";
        command = (String)command + String.format("--kafka-addr %s ", this.getKafkaAddresses());
        command = (String)command + String.format("--advertise-kafka-addr %s ", this.getKafkaAdvertisedAddresses());
        if (this.redpandaConfig.transactionEnabled) {
            command = (String)command + "--set redpanda.enable_idempotence=true ";
            command = (String)command + "--set redpanda.enable_transactions=true ";
        }
        this.copyFileToContainer(Transferable.of((byte[])((String)command).getBytes(StandardCharsets.UTF_8), (int)511), STARTER_SCRIPT);
    }

    private String getKafkaAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        if (this.useSharedNetwork) {
            addresses.add("PLAINTEXT://0.0.0.0:29092");
        }
        addresses.add("OUTSIDE://0.0.0.0:9092");
        return String.join((CharSequence)",", addresses);
    }

    private String getKafkaAdvertisedAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        if (this.useSharedNetwork) {
            addresses.add(String.format("PLAINTEXT://%s:29092", this.hostName));
        }
        addresses.add(String.format("OUTSIDE://%s:%d", this.getHost(), this.getMappedPort(9092)));
        return String.join((CharSequence)",", addresses);
    }

    protected void configure() {
        super.configure();
        this.addExposedPort(9092);
        this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"kafka");
        if (this.fixedExposedPort != null) {
            this.addFixedExposedPort(this.fixedExposedPort, 9092);
        }
    }

    public String getBootstrapServers() {
        return this.getKafkaAdvertisedAddresses();
    }
}

