/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.openshift.config.OpenshiftConfigFluent;
import io.quarkus.kubernetes.deployment.RouteConfig;

public class ApplyOpenshiftRouteConfigurator
extends Configurator<OpenshiftConfigFluent> {
    private final RouteConfig routeConfig;
    private final boolean defaultExpose;

    public ApplyOpenshiftRouteConfigurator(RouteConfig routeConfig, boolean defaultExpose) {
        this.routeConfig = routeConfig;
        this.defaultExpose = defaultExpose;
    }

    public void visit(OpenshiftConfigFluent config) {
        if (this.routeConfig.expose || this.defaultExpose) {
            OpenshiftConfigFluent.RouteNested routeBuilder = config.editOrNewRoute();
            routeBuilder.withExpose(Boolean.valueOf(true));
            if (this.routeConfig.host.isPresent()) {
                routeBuilder.withHost(this.routeConfig.host.get());
            }
            if (this.routeConfig.targetPort.isPresent()) {
                routeBuilder.withTargetPort(this.routeConfig.targetPort.get());
            }
            routeBuilder.endRoute();
        }
    }
}

