package io.quarkus.kubernetes.spi;

import io.quarkus.builder.item.MultiBuildItem;

/**
 * Produce this build item to request the Kubernetes extension to generate
 * a Kubernetes {@code RoleBinding} resource. The configuration here is limited;
 * in particular, you can't specify subjects of the role binding. The role will always
 * be bound to the application's service account.
 * <p>
 * Note that this can't be used to generate a {@code ClusterRoleBinding}.
 */
public final class KubernetesRoleBindingBuildItem extends MultiBuildItem {
    /**
     * Name of the generated {@code RoleBinding} resource.
     * Can be {@code null}, in which case the resource name is autogenerated.
     */
    private final String name;
    /**
     * Name of the bound role.
     */
    private final String role;
    /**
     * If {@code true}, the binding refers to a {@code ClusterRole}, otherwise to a namespaced {@code Role}.
     */
    private final boolean clusterWide;

    public KubernetesRoleBindingBuildItem(String role, boolean clusterWide) {
        this(null, role, clusterWide);
    }

    public KubernetesRoleBindingBuildItem(String name, String role, boolean clusterWide) {
        this.name = name;
        this.role = role;
        this.clusterWide = clusterWide;
    }

    public String getName() {
        return this.name;
    }

    public String getRole() {
        return this.role;
    }

    public boolean isClusterWide() {
        return clusterWide;
    }
}
