/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime.devconsole;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.liquibase.LiquibaseFactory;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.enterprise.inject.Any;

public class LiquibaseFactoriesSupplier
implements Supplier<Collection<LiquibaseFactory>> {
    @Override
    public Collection<LiquibaseFactory> get() {
        InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseFactory.class, new Annotation[]{Any.Literal.INSTANCE});
        if (liquibaseFactoryInstance.isUnsatisfied()) {
            return Collections.emptySet();
        }
        TreeSet<LiquibaseFactory> liquibaseFactories = new TreeSet<LiquibaseFactory>(LiquibaseFactoryComparator.INSTANCE);
        for (InstanceHandle liquibaseFactoryHandle : liquibaseFactoryInstance.handles()) {
            liquibaseFactories.add((LiquibaseFactory)liquibaseFactoryHandle.get());
        }
        return liquibaseFactories;
    }

    private static class LiquibaseFactoryComparator
    implements Comparator<LiquibaseFactory> {
        private static final LiquibaseFactoryComparator INSTANCE = new LiquibaseFactoryComparator();

        private LiquibaseFactoryComparator() {
        }

        @Override
        public int compare(LiquibaseFactory o1, LiquibaseFactory o2) {
            String dataSourceName1 = o1.getDataSourceName();
            String dataSourceName2 = o2.getDataSourceName();
            if (DataSourceUtil.isDefault((String)dataSourceName1)) {
                return -1;
            }
            if (DataSourceUtil.isDefault((String)dataSourceName2)) {
                return 1;
            }
            return dataSourceName1.compareTo(dataSourceName2);
        }
    }
}

