/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Mail;
import io.quarkus.mailer.Mailer;
import io.quarkus.mailer.ReactiveMailer;
import io.quarkus.runtime.BlockingOperationControl;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class BlockingMailerImpl
implements Mailer {
    @Inject
    ReactiveMailer mailer;

    @Override
    public void send(Mail ... mails) {
        if (!BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("Attempted a blocking operation from the IO thread. If you want to send mail from an IO thread please use ReactiveMailer instead, or dispatch to a worker thread to use the blocking mailer.");
        }
        this.mailer.send(mails).toCompletableFuture().join();
    }
}

