/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.creator.AppCreationPhase;
import io.quarkus.creator.AppCreator;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.phase.augment.AugmentOutcome;
import io.quarkus.creator.phase.augment.AugmentPhase;
import io.quarkus.creator.phase.curate.CurateOutcome;
import io.quarkus.creator.phase.nativeimage.NativeImageOutcome;
import io.quarkus.creator.phase.nativeimage.NativeImagePhase;
import io.quarkus.creator.phase.runnerjar.RunnerJarOutcome;
import io.quarkus.creator.phase.runnerjar.RunnerJarPhase;
import io.quarkus.maven.MojoLogger;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="native-image", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class NativeImageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${java.home}", required=true, readonly=true)
    public File javaHome;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/wiring-classes")
    private File wiringClassesDirectory;
    @Parameter(defaultValue="false")
    private boolean reportErrorsAtRuntime;
    @Parameter(defaultValue="false")
    private boolean debugSymbols;
    @Parameter(defaultValue="${native-image.debug-build-process}")
    private boolean debugBuildProcess;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(defaultValue="${native-image.new-server}")
    private boolean cleanupServer;
    @Parameter
    private boolean enableHttpUrlHandler;
    @Parameter
    private boolean enableHttpsUrlHandler;
    @Parameter
    private boolean enableAllSecurityServices;
    @Parameter
    private boolean enableRetainedHeapReporting;
    @Parameter
    private boolean enableIsolates;
    @Parameter
    private boolean enableCodeSizeReporting;
    @Parameter(defaultValue="${env.GRAALVM_HOME}")
    private String graalvmHome;
    @Parameter(defaultValue="false")
    private boolean enableServer;
    @Parameter(defaultValue="false")
    private boolean enableJni;
    @Parameter(defaultValue="false")
    private boolean autoServiceLoaderRegistration;
    @Parameter(defaultValue="false")
    private boolean dumpProxies;
    @Parameter(defaultValue="${native-image.xmx}")
    private String nativeImageXmx;
    @Parameter(defaultValue="${native-image.docker-build}")
    private String dockerBuild;
    @Parameter(defaultValue="${native-image.container-runtime}")
    private String containerRuntime;
    @Parameter(defaultValue="${native-image.container-runtime-options}")
    private String containerRuntimeOptions;
    @Parameter(defaultValue="false")
    private boolean enableVMInspection;
    @Parameter(defaultValue="true")
    private boolean fullStackTraces;
    @Parameter(defaultValue="${native-image.disable-reports}")
    private boolean disableReports;
    @Parameter
    private List<String> additionalBuildArgs;
    @Parameter(defaultValue="false")
    private boolean addAllCharsets;
    @Parameter(defaultValue="false")
    private boolean enableFallbackImages;
    @Parameter(defaultValue="true")
    private boolean reportExceptionStackTraces;
    @Parameter(required=false, property="quarkus.appArtifact")
    private String appArtifact;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;

    public NativeImageMojo() {
        MojoLogger.logSupplier = () -> ((NativeImageMojo)this).getLog();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom") && this.appArtifact == null) {
            this.getLog().info((CharSequence)"Type of the artifact is POM and appArtifact parameter has not been set, skipping native-image goal");
            return;
        }
        AppCreator.Builder creatorBuilder = AppCreator.builder();
        CurateOutcome curateOutcome = null;
        AugmentOutcome augmentOutcome = null;
        RunnerJarOutcome runnerJarOutcome = null;
        if (!this.buildDir.isDirectory() || !new File(this.buildDir, "lib").isDirectory()) {
            AppModel appModel;
            BootstrapAppModelResolver modelResolver;
            AppArtifact appCoords;
            AppArtifact managingProject = null;
            DefaultArtifact appMvnArtifact = null;
            if (this.appArtifact == null) {
                appMvnArtifact = new DefaultArtifact(this.project.getArtifact().getGroupId(), this.project.getArtifact().getArtifactId(), this.project.getArtifact().getClassifier(), this.project.getArtifact().getArtifactHandler().getExtension(), this.project.getArtifact().getVersion());
                appCoords = new AppArtifact(appMvnArtifact.getGroupId(), appMvnArtifact.getArtifactId(), appMvnArtifact.getClassifier(), appMvnArtifact.getExtension(), appMvnArtifact.getVersion());
            } else {
                String[] coordsArr = this.appArtifact.split(":");
                if (coordsArr.length < 2 || coordsArr.length > 5) {
                    throw new MojoExecutionException("appArtifact expression " + this.appArtifact + " does not follow format groupId:artifactId:classifier:type:version");
                }
                String groupId = coordsArr[0];
                String artifactId = coordsArr[1];
                String classifier = "";
                String type = "jar";
                String version = null;
                if (coordsArr.length == 3) {
                    version = coordsArr[2];
                } else if (coordsArr.length > 3) {
                    classifier = coordsArr[2] == null ? "" : coordsArr[2];
                    String string = type = coordsArr[3] == null ? "jar" : coordsArr[3];
                    if (coordsArr.length > 4) {
                        version = coordsArr[4];
                    }
                }
                if (version == null) {
                    for (org.apache.maven.artifact.Artifact dep : this.project.getArtifacts()) {
                        if (!dep.getArtifactId().equals(artifactId) || !dep.getGroupId().equals(groupId) || !dep.getClassifier().equals(classifier) || !dep.getType().equals(type)) continue;
                        appMvnArtifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getArtifactHandler().getExtension(), dep.getVersion());
                        break;
                    }
                    if (appMvnArtifact == null) {
                        throw new MojoExecutionException("Failed to locate " + this.appArtifact + " among the project dependencies");
                    }
                    appCoords = new AppArtifact(appMvnArtifact.getGroupId(), appMvnArtifact.getArtifactId(), appMvnArtifact.getClassifier(), appMvnArtifact.getExtension(), appMvnArtifact.getVersion());
                } else {
                    appCoords = new AppArtifact(groupId, artifactId, classifier, type, version);
                    appMvnArtifact = new DefaultArtifact(groupId, artifactId, classifier, type, version);
                }
                managingProject = new AppArtifact(this.project.getArtifact().getGroupId(), this.project.getArtifact().getArtifactId(), this.project.getArtifact().getClassifier(), this.project.getArtifact().getArtifactHandler().getExtension(), this.project.getArtifact().getVersion());
            }
            try {
                MavenArtifactResolver mvn = MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem).setRepositorySystemSession(this.repoSession).setRemoteRepositories(this.repos).build();
                appCoords.setPath(mvn.resolve((Artifact)appMvnArtifact).getArtifact().getFile().toPath());
                modelResolver = new BootstrapAppModelResolver(mvn);
                appModel = modelResolver.resolveManagedModel(appCoords, Collections.emptyList(), managingProject);
            }
            catch (AppModelResolverException e) {
                throw new MojoExecutionException("Failed to resolve application model dependencies for " + appCoords, (Exception)((Object)e));
            }
            creatorBuilder.addPhase((AppCreationPhase)new AugmentPhase().setAppClassesDir(new File(this.outputDirectory, "classes").toPath()).setWiringClassesDir(this.wiringClassesDirectory.toPath()).setBuildSystemProperties(this.project.getProperties())).addPhase((AppCreationPhase)new RunnerJarPhase().setFinalName(this.finalName)).setWorkDir(this.buildDir.toPath());
            curateOutcome = CurateOutcome.builder().setAppModelResolver((AppModelResolver)modelResolver).setAppModel(appModel).build();
        } else {
            augmentOutcome = new AugmentOutcome(){
                final Path classesDir;
                {
                    this.classesDir = new File(NativeImageMojo.this.outputDirectory, "classes").toPath();
                }

                public Path getAppClassesDir() {
                    return this.classesDir;
                }

                public Path getTransformedClassesDir() {
                    throw new UnsupportedOperationException();
                }

                public Path getWiringClassesDir() {
                    throw new UnsupportedOperationException();
                }

                public Path getConfigDir() {
                    return this.classesDir;
                }

                public Map<Path, Set<String>> getTransformedClassesByJar() {
                    return Collections.emptyMap();
                }
            };
            runnerJarOutcome = new RunnerJarOutcome(){
                final Path runnerJar;
                final Path originalJar;
                {
                    this.runnerJar = NativeImageMojo.this.buildDir.toPath().resolve(NativeImageMojo.this.finalName + "-runner.jar");
                    this.originalJar = NativeImageMojo.this.buildDir.toPath().resolve(NativeImageMojo.this.finalName + ".jar");
                }

                public Path getRunnerJar() {
                    return this.runnerJar;
                }

                public Path getLibDir() {
                    return this.runnerJar.getParent().resolve("lib");
                }

                public Path getOriginalJar() {
                    return this.originalJar;
                }
            };
        }
        creatorBuilder.addPhase((AppCreationPhase)new NativeImagePhase().setAddAllCharsets(this.addAllCharsets).setAdditionalBuildArgs(this.additionalBuildArgs).setAutoServiceLoaderRegistration(this.autoServiceLoaderRegistration).setOutputDir(this.buildDir.toPath()).setCleanupServer(this.cleanupServer).setDebugBuildProcess(this.debugBuildProcess).setDebugSymbols(this.debugSymbols).setDisableReports(this.disableReports).setDockerBuild(this.dockerBuild).setContainerRuntime(this.containerRuntime).setContainerRuntimeOptions(this.containerRuntimeOptions).setDumpProxies(this.dumpProxies).setEnableAllSecurityServices(this.enableAllSecurityServices).setEnableCodeSizeReporting(this.enableCodeSizeReporting).setEnableFallbackImages(this.enableFallbackImages).setEnableHttpsUrlHandler(this.enableHttpsUrlHandler).setEnableHttpUrlHandler(this.enableHttpUrlHandler).setEnableIsolates(this.enableIsolates).setEnableJni(this.enableJni).setEnableRetainedHeapReporting(this.enableRetainedHeapReporting).setEnableServer(this.enableServer).setEnableVMInspection(this.enableVMInspection).setFullStackTraces(this.fullStackTraces).setGraalvmHome(this.graalvmHome).setJavaHome(this.javaHome).setNativeImageXmx(this.nativeImageXmx).setReportErrorsAtRuntime(this.reportErrorsAtRuntime).setReportExceptionStackTraces(this.reportExceptionStackTraces));
        try (AppCreator appCreator = creatorBuilder.build();){
            if (curateOutcome != null) {
                appCreator.pushOutcome(CurateOutcome.class, (Object)curateOutcome);
            }
            if (augmentOutcome != null) {
                appCreator.pushOutcome(AugmentOutcome.class, (Object)augmentOutcome);
            }
            if (runnerJarOutcome != null) {
                appCreator.pushOutcome(RunnerJarOutcome.class, (Object)runnerJarOutcome);
            }
            appCreator.resolveOutcome(NativeImageOutcome.class);
        }
        catch (AppCreatorException e) {
            throw new MojoExecutionException("Failed to generate a native image", (Exception)((Object)e));
        }
    }
}

