/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.quarkus.arc.Arc;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.MethodParameterDescriptor;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Merge;
import io.smallrye.reactive.messaging.keyed.KeyValueExtractor;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;

public class QuarkusMediatorConfiguration
implements MediatorConfiguration {
    private String beanId;
    private String methodName;
    private Class<?> returnType;
    private Class<?>[] parameterTypes;
    private Shape shape;
    private List<String> incomings = new ArrayList<String>();
    private List<String> outgoings = new ArrayList<String>();
    private Acknowledgment.Strategy acknowledgment;
    private Integer broadcastValue;
    private MediatorConfiguration.Production production = MediatorConfiguration.Production.NONE;
    private MediatorConfiguration.Consumption consumption = MediatorConfiguration.Consumption.NONE;
    private boolean useBuilderTypes = false;
    private Merge.Mode merge;
    private Class<? extends Invoker> invokerClass;
    private boolean blocking;
    private boolean blockingExecutionOrdered;
    private String workerPoolName;
    private Type ingestedPayload;
    private boolean useReactiveStreams = false;
    private MethodParameterDescriptor descriptor;
    private Type keyType;
    private Type valueType;
    private Class<? extends KeyValueExtractor> keyed;
    private boolean hasTargetedOutput = false;

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    public Bean<?> getBean() {
        return Arc.container().bean(this.beanId);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Shape shape() {
        return this.shape;
    }

    public List<String> getIncoming() {
        return this.incomings;
    }

    public void setIncomings(List<String> incomings) {
        this.incomings = incomings;
    }

    public String getOutgoing() {
        return this.outgoings.get(0);
    }

    public List<String> getOutgoings() {
        return this.outgoings;
    }

    public void setOutgoings(List<String> outgoings) {
        this.outgoings = outgoings;
    }

    public Acknowledgment.Strategy getAcknowledgment() {
        return this.acknowledgment;
    }

    public void setAcknowledgment(Acknowledgment.Strategy acknowledgment) {
        this.acknowledgment = acknowledgment;
    }

    public Integer getBroadcastValue() {
        return this.broadcastValue;
    }

    public void setBroadcastValue(Integer broadcastValue) {
        this.broadcastValue = broadcastValue;
    }

    public boolean getBroadcast() {
        return this.broadcastValue != null;
    }

    public MediatorConfiguration.Production getProduction() {
        return this.production;
    }

    public void setProduction(MediatorConfiguration.Production production) {
        this.production = production;
    }

    public MediatorConfiguration.Production production() {
        return this.production;
    }

    public MediatorConfiguration.Consumption getConsumption() {
        return this.consumption;
    }

    public void setConsumption(MediatorConfiguration.Consumption consumption) {
        this.consumption = consumption;
    }

    public MediatorConfiguration.Consumption consumption() {
        return this.consumption;
    }

    public boolean isUseBuilderTypes() {
        return this.useBuilderTypes;
    }

    public void setUseBuilderTypes(boolean useBuilderTypes) {
        this.useBuilderTypes = useBuilderTypes;
    }

    public boolean usesBuilderTypes() {
        return this.useBuilderTypes;
    }

    public Merge.Mode getMerge() {
        return this.merge;
    }

    public void setMerge(Merge.Mode merge) {
        this.merge = merge;
    }

    public Class<? extends Invoker> getInvokerClass() {
        return this.invokerClass;
    }

    public Type getIngestedPayloadType() {
        return this.ingestedPayload;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public Class<? extends KeyValueExtractor> getKeyed() {
        return this.keyed;
    }

    public void setIngestedPayloadType(Type ingestedPayload) {
        this.ingestedPayload = ingestedPayload;
    }

    public void setInvokerClass(Class<? extends Invoker> invokerClass) {
        this.invokerClass = invokerClass;
    }

    public String methodAsString() {
        if (Arc.container() != null && this.getBean() != null) {
            return this.getBean().getBeanClass().getName() + "#" + this.getMethodName();
        }
        return this.getMethodName();
    }

    public Method getMethod() {
        throw new UnsupportedOperationException("getMethod is not meant to be called on " + this.getClass().getName());
    }

    public int getNumberOfSubscriberBeforeConnecting() {
        if (!this.getBroadcast()) {
            return -1;
        }
        return this.broadcastValue;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public String getWorkerPoolName() {
        return this.workerPoolName;
    }

    public boolean isBlockingExecutionOrdered() {
        return this.blockingExecutionOrdered;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setBlockingExecutionOrdered(boolean blockingExecutionOrdered) {
        this.blockingExecutionOrdered = blockingExecutionOrdered;
    }

    public void setWorkerPoolName(String workerPoolName) {
        this.workerPoolName = workerPoolName;
    }

    public boolean isUseReactiveStreams() {
        return this.useReactiveStreams;
    }

    public void setUseReactiveStreams(boolean usesReactiveStreams) {
        this.useReactiveStreams = usesReactiveStreams;
    }

    public boolean usesReactiveStreams() {
        return this.useReactiveStreams;
    }

    public MethodParameterDescriptor getParameterDescriptor() {
        return this.descriptor;
    }

    public void setParameterDescriptor(MethodParameterDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setKeyType(Type keyType) {
        this.keyType = keyType;
    }

    public void setValueType(Type valueType) {
        this.valueType = valueType;
    }

    public void setKeyed(Class<? extends KeyValueExtractor> keyed) {
        this.keyed = keyed;
    }

    public boolean hasTargetedOutput() {
        return this.hasTargetedOutput;
    }

    public boolean isHasTargetedOutput() {
        return this.hasTargetedOutput;
    }

    public void setHasTargetedOutput(boolean hasTargetedOutput) {
        this.hasTargetedOutput = hasTargetedOutput;
    }
}

