/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.micrometer.runtime.HttpClientMetricsTagsContributor;
import io.quarkus.micrometer.runtime.HttpServerMetricsTagsContributor;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.vertx.core.deployment.VertxOptionsConsumerBuildItem;
import java.util.function.BooleanSupplier;

@BuildSteps(onlyIf={VertxBinderEnabled.class})
public class VertxBinderProcessor {
    static final String METRIC_OPTIONS_CLASS_NAME = "io.vertx.core.metrics.MetricsOptions";
    static final Class<?> METRIC_OPTIONS_CLASS = MicrometerRecorder.getClassForName((String)"io.vertx.core.metrics.MetricsOptions");

    @BuildStep
    UnremovableBeanBuildItem unremoveableAdditionalHttpServerMetrics() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{HttpServerMetricsTagsContributor.class});
    }

    @BuildStep
    UnremovableBeanBuildItem unremoveableAdditionalHttpClientMetrics() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{HttpClientMetricsTagsContributor.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    VertxOptionsConsumerBuildItem build(VertxMeterBinderRecorder recorder) {
        return new VertxOptionsConsumerBuildItem(recorder.setVertxMetricsOptions(), 3000);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    void setVertxConfig(VertxMeterBinderRecorder recorder) {
        recorder.configureBinderAdapter();
    }

    static class VertxBinderEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        VertxBinderEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return METRIC_OPTIONS_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder.vertx);
        }
    }
}

