/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.binder.netty.NettyMetricsProvider;
import io.quarkus.micrometer.runtime.binder.netty.ReactiveNettyMetricsProvider;
import io.quarkus.micrometer.runtime.binder.netty.VertxNettyAllocatorMetricsProvider;
import io.quarkus.micrometer.runtime.binder.netty.VertxNettyEventExecutorMetricsProvider;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;

public class NettyBinderProcessor {
    static final String NETTY_ALLOCATOR_METRICS_NAME = "io.micrometer.core.instrument.binder.netty4.NettyAllocatorMetrics";
    static final Class<?> NETTY_ALLOCATOR_METRICS_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.core.instrument.binder.netty4.NettyAllocatorMetrics");
    static final String NETTY_EVENT_EXECUTOR_METRICS_NAME = "io.micrometer.core.instrument.binder.netty4.NettyEventExecutorMetrics";
    static final Class<?> NETTY_EVENT_EXECUTOR_METRICS_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.core.instrument.binder.netty4.NettyEventExecutorMetrics");
    static final String NETTY_BYTE_BUF_ALLOCATOR_NAME = "io.netty.buffer.PooledByteBufAllocator";
    static final Class<?> NETTY_BYTE_BUF_ALLOCATOR_CLASS = MicrometerRecorder.getClassForName((String)"io.netty.buffer.PooledByteBufAllocator");
    static final String VERTX_BYTE_BUF_ALLOCATOR_NAME = "io.vertx.core.buffer.impl.VertxByteBufAllocator";
    static final Class<?> VERTX_BYTE_BUF_ALLOCATOR_CLASS = MicrometerRecorder.getClassForName((String)"io.vertx.core.buffer.impl.VertxByteBufAllocator");
    static final String REACTIVE_USAGE_NAME = "org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormUpload";
    static final Class<?> REACTIVE_USAGE_CLASS = MicrometerRecorder.getClassForName((String)"org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormUpload");
    static final String VERTX_NAME = "io.vertx.core.Vertx";
    static final Class<?> VERTX_CLASS = MicrometerRecorder.getClassForName((String)"io.vertx.core.Vertx");

    @BuildStep(onlyIf={NettySupportEnabled.class})
    void createNettyNettyAllocatorMetrics(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(NettyMetricsProvider.class));
    }

    @BuildStep(onlyIf={VertxAllocatorSupportEnabled.class})
    void createVertxNettyAllocatorMetrics(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(VertxNettyAllocatorMetricsProvider.class));
    }

    @BuildStep(onlyIf={VertxEventExecutorSupportEnabled.class})
    void createVertxNettyEventExecutorMetrics(BuildProducer<AdditionalBeanBuildItem> beans, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.vertx.core")) {
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(VertxNettyEventExecutorMetricsProvider.class));
        }
    }

    @BuildStep(onlyIf={ReactiveSupportEnabled.class})
    void createReactiveNettyAllocatorMetrics(BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ReactiveNettyMetricsProvider.class));
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{REACTIVE_USAGE_NAME}).fields().build());
    }

    static class ReactiveSupportEnabled
    extends AbstractSupportEnabled {
        MicrometerConfig mConfig;

        ReactiveSupportEnabled() {
        }

        @Override
        MicrometerConfig getMicrometerConfig() {
            return this.mConfig;
        }

        @Override
        Class<?> getCheckClass() {
            return REACTIVE_USAGE_CLASS;
        }
    }

    static class VertxEventExecutorSupportEnabled
    extends AbstractSupportEnabled {
        MicrometerConfig mConfig;

        VertxEventExecutorSupportEnabled() {
        }

        @Override
        MicrometerConfig getMicrometerConfig() {
            return this.mConfig;
        }

        @Override
        Class<?> metricsClass() {
            return NETTY_EVENT_EXECUTOR_METRICS_CLASS;
        }

        @Override
        Class<?> getCheckClass() {
            return VERTX_CLASS;
        }
    }

    static class VertxAllocatorSupportEnabled
    extends AbstractSupportEnabled {
        MicrometerConfig mConfig;

        VertxAllocatorSupportEnabled() {
        }

        @Override
        MicrometerConfig getMicrometerConfig() {
            return this.mConfig;
        }

        @Override
        Class<?> getCheckClass() {
            return VERTX_BYTE_BUF_ALLOCATOR_CLASS;
        }
    }

    static class NettySupportEnabled
    extends AbstractSupportEnabled {
        MicrometerConfig mConfig;

        NettySupportEnabled() {
        }

        @Override
        MicrometerConfig getMicrometerConfig() {
            return this.mConfig;
        }

        @Override
        Class<?> getCheckClass() {
            return NETTY_BYTE_BUF_ALLOCATOR_CLASS;
        }
    }

    private static abstract class AbstractSupportEnabled
    implements BooleanSupplier {
        private AbstractSupportEnabled() {
        }

        abstract MicrometerConfig getMicrometerConfig();

        Class<?> metricsClass() {
            return NETTY_ALLOCATOR_METRICS_CLASS;
        }

        abstract Class<?> getCheckClass();

        @Override
        public boolean getAsBoolean() {
            return this.metricsClass() != null && this.getCheckClass() != null && this.getMicrometerConfig().checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.getMicrometerConfig().binder.netty);
        }
    }
}

