/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.micrometer.deployment.MicrometerProcessor;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.undertow.deployment.FilterBuildItem;
import jakarta.inject.Singleton;
import jakarta.servlet.DispatcherType;
import java.util.function.BooleanSupplier;

public class HttpBinderProcessor {
    static final String HTTP_METER_FILTER_CONFIGURATION = "io.quarkus.micrometer.runtime.binder.HttpMeterFilterProvider";
    static final String RESTEASY_CONTAINER_FILTER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderRestEasyContainerFilter";
    static final String RESTEASY_REACTIVE_CONTAINER_FILTER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderRestEasyReactiveContainerFilter";
    static final String UNDERTOW_SERVLET_FILTER_CLASS_NAME = "io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderUndertowServletFilter";
    private static final String REST_CLIENT_REQUEST_FILTER = "jakarta.ws.rs.client.ClientRequestFilter";
    private static final String REST_CLIENT_METRICS_FILTER = "io.quarkus.micrometer.runtime.binder.RestClientMetricsFilter";

    @BuildStep(onlyIf={MicrometerProcessor.MicrometerEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SyntheticBeanBuildItem enableHttpBinders(MicrometerRecorder recorder, MicrometerConfig buildTimeConfig, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        boolean clientEnabled = buildTimeConfig.isEnabled((MicrometerConfig.CapabilityEnabled)buildTimeConfig.binder().httpClient());
        boolean serverEnabled = buildTimeConfig.isEnabled((MicrometerConfig.CapabilityEnabled)buildTimeConfig.binder().httpServer());
        if (clientEnabled || serverEnabled) {
            this.createAdditionalBean(additionalBeans, HTTP_METER_FILTER_CONFIGURATION);
        }
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(HttpBinderConfiguration.class).scope(Singleton.class)).setRuntimeInit().unremovable()).runtimeValue(recorder.configureHttpMetrics(serverEnabled, clientEnabled)).done();
    }

    @BuildStep(onlyIf={HttpServerBinderEnabled.class})
    void enableHttpServerSupport(Capabilities capabilities, BuildProducer<FilterBuildItem> servletFilters, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent("io.quarkus.servlet")) {
            servletFilters.produce((BuildItem)FilterBuildItem.builder((String)"metricsFilter", (String)UNDERTOW_SERVLET_FILTER_CLASS_NAME).setAsyncSupported(true).addFilterUrlMapping("*", DispatcherType.FORWARD).addFilterUrlMapping("*", DispatcherType.INCLUDE).addFilterUrlMapping("*", DispatcherType.REQUEST).addFilterUrlMapping("*", DispatcherType.ASYNC).addFilterUrlMapping("*", DispatcherType.ERROR).build());
            this.createAdditionalBean(additionalBeans, UNDERTOW_SERVLET_FILTER_CLASS_NAME);
        }
    }

    @BuildStep(onlyIf={HttpClientBinderEnabled.class})
    void registerProvider(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexed, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalIndexed.produce((BuildItem)new AdditionalIndexedClassesBuildItem(REST_CLIENT_METRICS_FILTER));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{REST_CLIENT_METRICS_FILTER}));
    }

    private void createAdditionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans, String className) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(className).setUnremovable().build());
    }

    static class HttpClientBinderEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        HttpClientBinderEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return QuarkusClassLoader.isClassPresentAtRuntime((String)HttpBinderProcessor.REST_CLIENT_REQUEST_FILTER) && this.mConfig.isEnabled((MicrometerConfig.CapabilityEnabled)this.mConfig.binder().httpClient());
        }
    }

    static class HttpServerBinderEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        HttpServerBinderEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.mConfig.isEnabled((MicrometerConfig.CapabilityEnabled)this.mConfig.binder().vertx()) && this.mConfig.isEnabled((MicrometerConfig.CapabilityEnabled)this.mConfig.binder().httpServer());
        }
    }
}

