/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.quarkus.arc.Arc;
import io.quarkus.micrometer.runtime.CompositeRegistryCreator;
import io.quarkus.micrometer.runtime.MeterFilterConstraint;
import io.quarkus.micrometer.runtime.MeterRegistryCustomizer;
import io.quarkus.micrometer.runtime.MeterRegistryCustomizerConstraint;
import io.quarkus.micrometer.runtime.MicrometerMetricsFactory;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.JVMInfoBinder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.config.runtime.HttpClientConfig;
import io.quarkus.micrometer.runtime.config.runtime.HttpServerConfig;
import io.quarkus.micrometer.runtime.config.runtime.VertxConfig;
import io.quarkus.runtime.ImageMode;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.metrics.MetricsFactory;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

@Recorder
public class MicrometerRecorder {
    private static final Logger log = Logger.getLogger(MicrometerRecorder.class);
    static final String DEFAULT_EXCEPTION_TAG_VALUE = "none";
    static MicrometerMetricsFactory factory;
    public static String nonApplicationUri;
    public static String httpRootUri;

    public RuntimeValue<MeterRegistry> createRootRegistry(MicrometerConfig config, String qUri, String httpUri) {
        factory = new MicrometerMetricsFactory(config, (MeterRegistry)Metrics.globalRegistry);
        nonApplicationUri = qUri;
        httpRootUri = httpUri;
        return new RuntimeValue((Object)Metrics.globalRegistry);
    }

    public void configureRegistries(MicrometerConfig config, Set<Class<? extends MeterRegistry>> registryClasses, ShutdownContext context) {
        BeanManager beanManager = Arc.container().beanManager();
        HashMap<Class<? extends MeterRegistry>, List<MeterFilter>> classMeterFilters = new HashMap<Class<? extends MeterRegistry>, List<MeterFilter>>(registryClasses.size());
        ArrayList<MeterFilter> globalFilters = new ArrayList<MeterFilter>();
        this.populateMeterFilters(registryClasses, beanManager, classMeterFilters, globalFilters);
        HashMap<Class<? extends MeterRegistry>, List<MeterRegistryCustomizer>> classMeterRegistryCustomizers = new HashMap<Class<? extends MeterRegistry>, List<MeterRegistryCustomizer>>(registryClasses.size());
        ArrayList<MeterRegistryCustomizer> globalMeterRegistryCustomizers = new ArrayList<MeterRegistryCustomizer>();
        this.populateMeterRegistryCustomizers(registryClasses, beanManager, classMeterRegistryCustomizers, globalMeterRegistryCustomizers);
        HashSet<Bean> beans = new HashSet<Bean>(beanManager.getBeans(MeterRegistry.class, new Annotation[]{Any.Literal.INSTANCE}));
        beans.removeIf(bean -> bean.getBeanClass().equals(CompositeRegistryCreator.class));
        this.applyMeterFilters((MeterRegistry)Metrics.globalRegistry, globalFilters);
        this.applyMeterRegistryCustomizers((MeterRegistry)Metrics.globalRegistry, globalMeterRegistryCustomizers);
        for (Bean i : beans) {
            MeterRegistry registry = (MeterRegistry)beanManager.getReference(i, MeterRegistry.class, beanManager.createCreationalContext((Contextual)i));
            if (registry == Metrics.globalRegistry || registry == null) continue;
            this.applyMeterFilters(registry, globalFilters);
            Class<?> registryClass = registry.getClass();
            this.applyMeterFilters(registry, (List)classMeterFilters.get(registryClass));
            List classSpecificCustomizers = classMeterRegistryCustomizers.getOrDefault(registryClass, Collections.emptyList());
            ArrayList<MeterRegistryCustomizer> newList = new ArrayList<MeterRegistryCustomizer>(globalMeterRegistryCustomizers.size() + classSpecificCustomizers.size());
            newList.addAll(globalMeterRegistryCustomizers);
            newList.addAll(classSpecificCustomizers);
            this.applyMeterRegistryCustomizers(registry, newList);
            log.debugf("Adding configured registry %s", registryClass, (Object)registry);
            Metrics.globalRegistry.add(registry);
        }
        final ArrayList<Object> autoCloseables = new ArrayList<Object>();
        if (config.checkBinderEnabledWithDefault(() -> config.binder.jvm)) {
            new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            JvmHeapPressureMetrics jvmHeapPressureMetrics = new JvmHeapPressureMetrics();
            jvmHeapPressureMetrics.bindTo((MeterRegistry)Metrics.globalRegistry);
            autoCloseables.add(jvmHeapPressureMetrics);
            new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new JVMInfoBinder().bindTo((MeterRegistry)Metrics.globalRegistry);
            if (ImageMode.current() == ImageMode.JVM) {
                JvmGcMetrics jvmGcMetrics = new JvmGcMetrics();
                jvmGcMetrics.bindTo((MeterRegistry)Metrics.globalRegistry);
                autoCloseables.add(jvmGcMetrics);
            }
        }
        if (config.checkBinderEnabledWithDefault(() -> config.binder.system)) {
            new UptimeMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            new FileDescriptorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        }
        Instance allBinders = beanManager.createInstance().select(MeterBinder.class, new Annotation[]{Any.Literal.INSTANCE});
        for (MeterBinder meterBinder : allBinders) {
            meterBinder.bindTo((MeterRegistry)Metrics.globalRegistry);
        }
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                if (LaunchMode.current() == LaunchMode.DEVELOPMENT) {
                    for (Meter meter : Metrics.globalRegistry.getMeters()) {
                        Metrics.globalRegistry.remove(meter);
                    }
                }
                for (MeterRegistry meterRegistry : new ArrayList(Metrics.globalRegistry.getRegistries())) {
                    meterRegistry.close();
                    Metrics.removeRegistry((MeterRegistry)meterRegistry);
                }
                for (AutoCloseable autoCloseable : autoCloseables) {
                    try {
                        autoCloseable.close();
                    }
                    catch (Exception e) {
                        log.error((Object)"Error closing", (Throwable)e);
                    }
                }
            }
        });
    }

    private void populateMeterFilters(Set<Class<? extends MeterRegistry>> registryClasses, BeanManager beanManager, Map<Class<? extends MeterRegistry>, List<MeterFilter>> classMeterFilters, List<MeterFilter> globalFilters) {
        Instance globalFilterInstance = beanManager.createInstance().select(MeterFilter.class, new Annotation[]{Default.Literal.INSTANCE});
        this.populateList(globalFilterInstance, globalFilters);
        log.debugf("Discovered global MeterFilters : %s", globalFilters);
        for (Class<? extends MeterRegistry> typeClass : registryClasses) {
            Instance classFilterInstance = beanManager.createInstance().select(MeterFilter.class, new Annotation[]{new MeterFilterConstraint.Literal(typeClass)});
            List classFilters = classMeterFilters.computeIfAbsent(typeClass, k -> new ArrayList());
            this.populateList(classFilterInstance, classFilters);
            log.debugf("Discovered MeterFilters for %s: %s", typeClass, (Object)classFilters);
        }
    }

    private void populateMeterRegistryCustomizers(Set<Class<? extends MeterRegistry>> registryClasses, BeanManager beanManager, Map<Class<? extends MeterRegistry>, List<MeterRegistryCustomizer>> classMeterRegistryCustomizers, List<MeterRegistryCustomizer> globalMeterRegistryCustomizers) {
        Instance globalFilterInstance = beanManager.createInstance().select(MeterRegistryCustomizer.class, new Annotation[]{Default.Literal.INSTANCE});
        this.populateList(globalFilterInstance, globalMeterRegistryCustomizers);
        log.debugf("Discovered global MeterRegistryCustomizer : %s", globalMeterRegistryCustomizers);
        log.debugf("Configuring Micrometer registries : %s", registryClasses);
        for (Class<? extends MeterRegistry> typeClass : registryClasses) {
            Instance classFilterInstance = beanManager.createInstance().select(MeterRegistryCustomizer.class, new Annotation[]{new MeterRegistryCustomizerConstraint.Literal(typeClass)});
            List classFilters = classMeterRegistryCustomizers.computeIfAbsent(typeClass, k -> new ArrayList());
            this.populateList(classFilterInstance, classFilters);
            log.debugf("Discovered MeterRegistryCustomizer for %s: %s", typeClass, (Object)classFilters);
        }
    }

    private <T> void populateList(Instance<T> filterInstance, List<T> meterFilters) {
        if (!filterInstance.isUnsatisfied()) {
            for (Object filter : filterInstance) {
                if (filter == null) continue;
                meterFilters.add(filter);
            }
        }
    }

    private void applyMeterFilters(MeterRegistry registry, List<MeterFilter> filters) {
        if (filters != null) {
            for (MeterFilter meterFilter : filters) {
                registry.config().meterFilter(meterFilter);
            }
        }
    }

    private void applyMeterRegistryCustomizers(MeterRegistry registry, List<MeterRegistryCustomizer> customizers) {
        if (customizers != null && !customizers.isEmpty()) {
            Collections.sort(customizers);
            for (MeterRegistryCustomizer customizer : customizers) {
                customizer.customize(registry);
            }
        }
    }

    public void registerMetrics(Consumer<MetricsFactory> consumer) {
        consumer.accept(factory);
    }

    public static Class<?> getClassForName(String classname) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classname, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        log.debugf("getClass: TCCL: %s ## %s : %s", (Object)Thread.currentThread().getContextClassLoader(), (Object)classname, (Object)(clazz != null ? 1 : 0));
        return clazz;
    }

    static String getExceptionTag(Throwable throwable) {
        if (throwable == null) {
            return DEFAULT_EXCEPTION_TAG_VALUE;
        }
        if (throwable.getCause() == null) {
            return throwable.getClass().getSimpleName();
        }
        return throwable.getCause().getClass().getSimpleName();
    }

    public RuntimeValue<HttpBinderConfiguration> configureHttpMetrics(boolean httpServerMetricsEnabled, boolean httpClientMetricsEnabled, HttpServerConfig serverConfig, HttpClientConfig clientConfig, VertxConfig vertxConfig) {
        return new RuntimeValue((Object)new HttpBinderConfiguration(httpServerMetricsEnabled, httpClientMetricsEnabled, serverConfig, clientConfig, vertxConfig));
    }

    static {
        nonApplicationUri = "/q/";
        httpRootUri = "/";
    }
}

