/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export;

import io.quarkus.micrometer.runtime.export.handlers.PrometheusHandler;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Consumer;

@Recorder
public class PrometheusRecorder {
    PrometheusHandler handler;
    private final VertxHttpBuildTimeConfig vertxHttpBuildTimeConfig;

    public PrometheusRecorder(VertxHttpBuildTimeConfig vertxHttpBuildTimeConfig) {
        this.vertxHttpBuildTimeConfig = vertxHttpBuildTimeConfig;
    }

    public Handler<RoutingContext> getHandler() {
        if (this.handler == null) {
            this.handler = new PrometheusHandler(this.vertxHttpBuildTimeConfig.enableCompression(), this.vertxHttpBuildTimeConfig.compressMediaTypes());
        }
        return this.handler;
    }

    public Consumer<Route> route() {
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.order(1).produces("text/plain");
                route.order(2).produces("application/openmetrics-text; version=1.0.0; charset=utf-8");
            }
        };
    }

    public Consumer<Route> fallbackRoute() {
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.order(4);
            }
        };
    }

    public Handler<RoutingContext> getFallbackHandler() {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext routingContext) {
                routingContext.response().setStatusCode(406).setStatusMessage("Micrometer prometheus endpoint does not support " + routingContext.request().getHeader(HttpHeaders.ACCEPT)).end();
            }
        };
    }
}

