/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export.exemplars;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.quarkus.micrometer.runtime.export.exemplars.OpenTelemetryContextUnwrapper;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import jakarta.enterprise.context.Dependent;
import java.util.function.Function;

@Dependent
public class OpenTelemetryExemplarContextUnwrapper
implements OpenTelemetryContextUnwrapper {
    @Override
    public <P, R> R executeInContext(Function<P, R> methodReference, P parameter, io.vertx.core.Context requestContext) {
        if (requestContext == null) {
            return methodReference.apply(parameter);
        }
        Context newContext = QuarkusContextStorage.getOtelContext((io.vertx.core.Context)requestContext);
        if (newContext == null) {
            return methodReference.apply(parameter);
        }
        Context oldContext = QuarkusContextStorage.INSTANCE.current();
        try (Scope scope = QuarkusContextStorage.INSTANCE.attach(newContext);){
            R r = methodReference.apply(parameter);
            return r;
        }
    }
}

