/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.arc.Unremovable;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpCommonTags;
import io.quarkus.micrometer.runtime.binder.RequestMetricInfo;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMeterBinderAdapter;
import io.vertx.core.http.HttpClientOptions;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.ext.Provider;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientResponseFilter;

@Unremovable
@Provider
public class RestClientMetricsFilter
implements ResteasyReactiveClientRequestFilter,
ResteasyReactiveClientResponseFilter {
    private static final String REQUEST_METRIC_PROPERTY = "restClientMetrics";
    private final MeterRegistry registry = Metrics.globalRegistry;
    private final HttpBinderConfiguration httpMetricsConfig;
    private final Meter.MeterProvider<Timer> timer;

    @Inject
    public RestClientMetricsFilter(HttpBinderConfiguration httpMetricsConfig) {
        this.httpMetricsConfig = httpMetricsConfig;
        this.timer = Timer.builder((String)httpMetricsConfig.getHttpClientRequestsName()).withRegistry(this.registry);
    }

    public void filter(ResteasyReactiveClientRequestContext requestContext) {
        if (!this.httpMetricsConfig.isClientEnabled()) {
            return;
        }
        RestClientMetricInfo requestMetric = new RestClientMetricInfo((ClientRequestContext)requestContext);
        requestMetric.setSample(Timer.start((MeterRegistry)this.registry));
        requestContext.setProperty(REQUEST_METRIC_PROPERTY, (Object)requestMetric);
    }

    public void filter(ResteasyReactiveClientRequestContext requestContext, ClientResponseContext responseContext) {
        if (!this.httpMetricsConfig.isClientEnabled()) {
            return;
        }
        RequestMetricInfo requestMetric = this.getRequestMetric((ClientRequestContext)requestContext);
        if (requestMetric != null) {
            String templatePath = (String)requestContext.getProperty("UrlPathTemplate");
            String requestPath = requestMetric.getNormalizedUriPath(this.httpMetricsConfig.getClientMatchPatterns(), this.httpMetricsConfig.getClientIgnorePatterns(), templatePath == null ? requestContext.getUri().getPath() : templatePath);
            if (requestPath != null) {
                Timer.Sample sample = requestMetric.getSample();
                int statusCode = responseContext.getStatus();
                sample.stop((Timer)this.timer.withTags((Iterable)Tags.of((Tag[])new Tag[]{HttpCommonTags.method(requestContext.getMethod()), HttpCommonTags.uri(requestPath, requestContext.getUri().getPath(), statusCode, this.httpMetricsConfig.isClientSuppress4xxErrors()), HttpCommonTags.outcome(statusCode), HttpCommonTags.status(statusCode), this.clientName(requestContext)})));
            }
        }
    }

    private RequestMetricInfo getRequestMetric(ClientRequestContext requestContext) {
        return (RequestMetricInfo)requestContext.getProperty(REQUEST_METRIC_PROPERTY);
    }

    private Tag clientName(ResteasyReactiveClientRequestContext requestContext) {
        String host = null;
        HttpClientOptions httpClientOptions = (HttpClientOptions)requestContext.unwrap(HttpClientOptions.class);
        if (httpClientOptions != null && httpClientOptions.getMetricsName() != null) {
            host = VertxMeterBinderAdapter.extractClientName(httpClientOptions.getMetricsName());
        } else if (requestContext.getUri().getHost() != null) {
            host = requestContext.getUri().getHost();
        }
        return Tag.of((String)"clientName", (String)(host != null ? host : "none"));
    }

    static class RestClientMetricInfo
    extends RequestMetricInfo {
        ClientRequestContext requestContext;

        RestClientMetricInfo(ClientRequestContext requestContext) {
            this.requestContext = requestContext;
        }
    }
}

