/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.deployment;

import io.netty.channel.EventLoopGroup;
import io.quarkus.arc.deployment.RuntimeBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateConfigBuildItem;
import io.quarkus.netty.BossGroup;
import io.quarkus.netty.runtime.NettyRecorder;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;

class NettyProcessor {
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    private static final Logger log = Logger.getLogger(NettyProcessor.class);

    NettyProcessor() {
    }

    @BuildStep
    SubstrateConfigBuildItem build() {
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"io.netty.channel.socket.nio.NioSocketChannel"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"io.netty.channel.socket.nio.NioServerSocketChannel"}));
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"java.util.LinkedHashMap"}));
        SubstrateConfigBuildItem.Builder builder = SubstrateConfigBuildItem.builder().addNativeImageSystemProperty("io.netty.noUnsafe", "true").addRuntimeInitializedClass("io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslEngine").addRuntimeInitializedClass("io.netty.handler.ssl.util.ThreadLocalInsecureRandom").addNativeImageSystemProperty("io.netty.leakDetection.level", "DISABLED");
        try {
            Class.forName("io.netty.handler.codec.http.HttpObjectEncoder");
            builder.addRuntimeReinitializedClass("io.netty.handler.codec.http2.Http2CodecUtil").addRuntimeInitializedClass("io.netty.handler.codec.http.HttpObjectEncoder").addRuntimeInitializedClass("io.netty.handler.codec.http2.DefaultHttp2FrameWriter").addRuntimeInitializedClass("io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty HTTP classes as they were not found");
        }
        return builder.build();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createExecutors(BuildProducer<RuntimeBeanBuildItem> runtimeBeanBuildItemBuildProducer, NettyRecorder recorder) {
        Supplier boss = recorder.createEventLoop(1);
        Supplier worker = recorder.createEventLoop(0);
        runtimeBeanBuildItemBuildProducer.produce((BuildItem)RuntimeBeanBuildItem.builder(EventLoopGroup.class).setSupplier(boss).setScope(ApplicationScoped.class).addQualifier(BossGroup.class).build());
        runtimeBeanBuildItemBuildProducer.produce((BuildItem)RuntimeBeanBuildItem.builder(EventLoopGroup.class).setSupplier(worker).setScope(ApplicationScoped.class).build());
    }
}

