/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.deployment;

import io.netty.util.internal.logging.AbstractInternalLogger;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jboss.logging.Logger;

public class JBossNettyLoggerFactory
extends InternalLoggerFactory {
    protected InternalLogger newInstance(String name) {
        return new JBossNettyInternalLogger(name);
    }

    private static final class JBossNettyInternalLogger
    extends AbstractInternalLogger {
        final Logger log;

        JBossNettyInternalLogger(String name) {
            super(name);
            this.log = Logger.getLogger((String)name);
        }

        public boolean isTraceEnabled() {
            return this.log.isTraceEnabled();
        }

        public void trace(String msg) {
            this.log.trace((Object)msg);
        }

        public void trace(String format, Object arg) {
            this.log.tracef(format, arg);
        }

        public void trace(String format, Object argA, Object argB) {
            this.log.tracef(format, argA, argB);
        }

        public void trace(String format, Object ... arguments) {
            this.log.tracef(format, arguments);
        }

        public void trace(String msg, Throwable t) {
            this.log.trace((Object)msg, t);
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void debug(String msg) {
            this.log.debug((Object)msg);
        }

        public void debug(String format, Object arg) {
            this.log.debugf(format, arg);
        }

        public void debug(String format, Object argA, Object argB) {
            this.log.debugf(format, argA, argB);
        }

        public void debug(String format, Object ... arguments) {
            this.log.debugf(format, arguments);
        }

        public void debug(String msg, Throwable t) {
            this.log.debug((Object)msg, t);
        }

        public boolean isInfoEnabled() {
            return this.log.isInfoEnabled();
        }

        public void info(String msg) {
            this.log.info((Object)msg);
        }

        public void info(String format, Object arg) {
            this.log.infof(format, arg);
        }

        public void info(String format, Object argA, Object argB) {
            this.log.infof(format, argA, argB);
        }

        public void info(String format, Object ... arguments) {
            this.log.infof(format, arguments);
        }

        public void info(String msg, Throwable t) {
            this.log.info((Object)msg, t);
        }

        public boolean isWarnEnabled() {
            return this.log.isEnabled(Logger.Level.WARN);
        }

        public void warn(String msg) {
            this.log.warn((Object)msg);
        }

        public void warn(String format, Object arg) {
            this.log.warnf(format, arg);
        }

        public void warn(String format, Object ... arguments) {
            this.log.warnf(format, arguments);
        }

        public void warn(String format, Object argA, Object argB) {
            this.log.warnf(format, argA, argB);
        }

        public void warn(String msg, Throwable t) {
            this.log.warn((Object)msg, t);
        }

        public boolean isErrorEnabled() {
            return this.log.isEnabled(Logger.Level.ERROR);
        }

        public void error(String msg) {
            this.log.error((Object)msg);
        }

        public void error(String format, Object arg) {
            this.log.errorf(format, arg);
        }

        public void error(String format, Object argA, Object argB) {
            this.log.errorf(format, argA, argB);
        }

        public void error(String format, Object ... arguments) {
            this.log.errorf(format, arguments);
        }

        public void error(String msg, Throwable t) {
            this.log.error((Object)msg, t);
        }
    }
}

