/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx;

import io.vertx.core.Context;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import java.util.Optional;

public class OpenTelemetryVertxMetricsFactory
implements VertxMetricsFactory {
    public VertxMetrics metrics(VertxOptions options) {
        return new VertxMetrics(){

            public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
                return new OpenTelemetryHttpServerMetrics();
            }
        };
    }

    public static class OpenTelemetryHttpServerMetrics
    implements HttpServerMetrics<MetricRequest, Object, Object> {
        public MetricRequest requestBegin(Object socketMetric, HttpRequest request) {
            return MetricRequest.request(request);
        }

        public void requestRouted(MetricRequest requestMetric, String route) {
            if (route != null) {
                requestMetric.getContext().ifPresent(context -> context.putLocal((Object)"VertxRoute", (Object)route));
            }
        }

        static final class MetricRequest {
            private final HttpRequest request;

            MetricRequest(HttpRequest request) {
                this.request = request;
            }

            Optional<Context> getContext() {
                if (this.request instanceof HttpServerRequestInternal) {
                    return Optional.of(((HttpServerRequestInternal)this.request).context());
                }
                return Optional.empty();
            }

            static MetricRequest request(HttpRequest httpRequest) {
                return new MetricRequest(httpRequest);
            }
        }
    }
}

