/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.NetworkAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.NetworkAttributesGetter;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.InstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.OpenTelemetryVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.VertxUtil;
import io.vertx.core.Context;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class SqlClientInstrumenterVertxTracer
implements InstrumenterVertxTracer<QueryTrace, QueryTrace> {
    private final Instrumenter<QueryTrace, QueryTrace> sqlClientInstrumenter;

    public SqlClientInstrumenterVertxTracer(OpenTelemetry openTelemetry, OTelRuntimeConfig runtimeConfig) {
        SqlClientAttributesGetter sqlClientAttributesGetter = new SqlClientAttributesGetter();
        InstrumenterBuilder serverBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)DbClientSpanNameExtractor.create((io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter)sqlClientAttributesGetter));
        serverBuilder.setEnabled(!runtimeConfig.sdkDisabled());
        this.sqlClientInstrumenter = serverBuilder.addAttributesExtractor(SqlClientAttributesExtractor.create((io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter)sqlClientAttributesGetter)).addAttributesExtractor((AttributesExtractor)NetworkAttributesExtractor.create((NetworkAttributesGetter)sqlClientAttributesGetter)).buildClientInstrumenter((queryTrace, key, value) -> {});
    }

    @Override
    public <R> boolean canHandle(R request, TagExtractor<R> tagExtractor) {
        if (request instanceof QueryTrace) {
            return true;
        }
        return "sql".equals(tagExtractor.extract(request).get("db.type"));
    }

    @Override
    public <R> OpenTelemetryVertxTracer.SpanOperation sendRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        QueryTrace queryTrace = QueryTrace.queryTrace(tagExtractor.extract(request));
        return InstrumenterVertxTracer.super.sendRequest(context, kind, policy, queryTrace, operation, (BiConsumer)headers, (TagExtractor)tagExtractor);
    }

    @Override
    public <R> void receiveResponse(Context context, R response, OpenTelemetryVertxTracer.SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        InstrumenterVertxTracer.super.receiveResponse(context, response, spanOperation, failure, tagExtractor);
    }

    @Override
    public Instrumenter<QueryTrace, QueryTrace> getReceiveRequestInstrumenter() {
        return null;
    }

    @Override
    public Instrumenter<QueryTrace, QueryTrace> getSendResponseInstrumenter() {
        return null;
    }

    @Override
    public Instrumenter<QueryTrace, QueryTrace> getSendRequestInstrumenter() {
        return this.sqlClientInstrumenter;
    }

    @Override
    public Instrumenter<QueryTrace, QueryTrace> getReceiveResponseInstrumenter() {
        return this.sqlClientInstrumenter;
    }

    static class SqlClientAttributesGetter
    implements io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter<QueryTrace, Object>,
    NetworkAttributesGetter<QueryTrace, Object> {
        SqlClientAttributesGetter() {
        }

        public Collection<String> getRawQueryTexts(QueryTrace queryTrace) {
            return queryTrace.rawStatement() != null && !queryTrace.rawStatement().isBlank() ? List.of(queryTrace.rawStatement()) : Collections.emptyList();
        }

        public String getDbSystem(QueryTrace queryTrace) {
            return queryTrace.system();
        }

        @Deprecated
        public String getUser(QueryTrace queryTrace) {
            return queryTrace.user();
        }

        public String getDbNamespace(QueryTrace queryTrace) {
            return null;
        }

        @Deprecated
        public String getConnectionString(QueryTrace queryTrace) {
            return queryTrace.connectionString();
        }

        public String getNetworkPeerAddress(QueryTrace queryTrace, Object object) {
            return queryTrace.peerAddress();
        }

        public Integer getNetworkPeerPort(QueryTrace queryTrace, Object object) {
            return queryTrace.peerPort();
        }
    }

    static class QueryTrace {
        private final Map<String, String> attributes;

        QueryTrace(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        static QueryTrace queryTrace(Map<String, String> attributes) {
            return new QueryTrace(attributes);
        }

        public String rawStatement() {
            return this.attributes.get("db.statement");
        }

        public String system() {
            return this.attributes.get("db.instance");
        }

        @Deprecated
        public String user() {
            return this.attributes.get("db.user");
        }

        public String instance() {
            return this.attributes.get("db.instance");
        }

        @Deprecated
        public String connectionString() {
            return this.attributes.get("peer.address");
        }

        public String peerAddress() {
            return VertxUtil.extractHostname(this.attributes.get("peer.address"));
        }

        public Integer peerPort() {
            return VertxUtil.extractPort(this.attributes.get("peer.address"));
        }
    }
}

