/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.hibernate.common.runtime;

import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.grammars.hql.HqlParserBaseVisitor;

public class CountParserVisitor
extends HqlParserBaseVisitor<String> {
    private int inSimpleQueryGroup;
    private StringBuilder sb = new StringBuilder();

    public String visitSimpleQueryGroup(HqlParser.SimpleQueryGroupContext ctx) {
        ++this.inSimpleQueryGroup;
        try {
            String string = (String)super.visitSimpleQueryGroup(ctx);
            return string;
        }
        finally {
            --this.inSimpleQueryGroup;
        }
    }

    public String visitQuery(HqlParser.QueryContext ctx) {
        super.visitQuery(ctx);
        if (this.inSimpleQueryGroup == 1 && ctx.selectClause() == null) {
            this.sb.append(" select count( * )");
        }
        return null;
    }

    public String visitSelectClause(HqlParser.SelectClauseContext ctx) {
        if (this.inSimpleQueryGroup == 1) {
            if (ctx.SELECT() != null) {
                ctx.SELECT().accept((ParseTreeVisitor)this);
            }
            if (ctx.DISTINCT() != null) {
                this.sb.append(" count(");
                ctx.DISTINCT().accept((ParseTreeVisitor)this);
                if (ctx.selectionList().children.size() != 1) {
                    throw new RuntimeException("Cannot count on more than one column");
                }
                ((ParseTree)ctx.selectionList().children.get(0)).accept((ParseTreeVisitor)this);
                this.sb.append(" )");
            } else {
                this.sb.append(" count( * )");
            }
        } else {
            super.visitSelectClause(ctx);
        }
        return null;
    }

    public String visitJoin(HqlParser.JoinContext ctx) {
        if (this.inSimpleQueryGroup == 1 && ctx.FETCH() != null) {
            return null;
        }
        return (String)super.visitJoin(ctx);
    }

    public String visitQueryOrder(HqlParser.QueryOrderContext ctx) {
        if (this.inSimpleQueryGroup == 1) {
            return null;
        }
        return (String)super.visitQueryOrder(ctx);
    }

    public String visitTerminal(TerminalNode node) {
        this.append(node.getText());
        return null;
    }

    protected String defaultResult() {
        return null;
    }

    protected String aggregateResult(String aggregate, String nextResult) {
        if (nextResult != null) {
            this.append(nextResult);
        }
        return null;
    }

    private void append(String nextResult) {
        if (!this.sb.isEmpty() && this.sb.charAt(this.sb.length() - 1) != '.' && !nextResult.equals(".")) {
            this.sb.append(" ");
        }
        this.sb.append(nextResult);
    }

    public String result() {
        return this.sb.toString();
    }
}

